define({"0":{y:0,u:"../Content/common_topics/LP_RSL15_welcome.htm",l:-1,t:"Welcome to the RSL15 documentation topics!",i:0.000447713649571742,a:"  RSL15 Introduction RSL15 is an ultra-low power secure Arm® Cortex®-M33 processor-based Bluetooth Low Energy 5.2 wireless MCU, designed for connected smart devices in industrial, medical and consumer applications. The comprehensive yet easy-to-use Software Development Kit (SDK) provides sample applications that demonstrate the hardware’s capabilities to enable security with the Integrated IoT Cybersecurity Platform, acquire sensor data in Smart Sense mode, configure the build-in power management, and utilize Bluetooth Low Energy features. Licensing Agreement The RSL15 licensing agreement is specified in Software Use Agreement - use and accept (ONIPLAW 08142020).pdf, found in the root directory of the installed RSL15 CMSIS-Pack. How to use this documentation This searchable resource contains all of our RSL15 manuals, with online-format advantages: Search across all the manuals or within a single manual, from one convenient search bar. Choose by clicking the search options icon:  Search ..."},"1":{y:0,u:"../Content/getting_started_rsl15/gs_LandingPage.htm",l:-1,t:"RSL15 Getting Started Guide",i:0.000542857707927759,a:"RSL15 Getting Started Guide This group of topics describes how to begin using the RSL Central mobile app and the RSL15 Software Development Kit (SDK) with the RSL15 Evaluation and Development Board (EVB). It provides the prerequisites and instructions necessary to install the relevant software, connect the EVB, and get started. The RSL15 licensing agreement is specified in Software Use Agreement - use and accept (ONIPLAW 08142020).pdf, found in the root directory of the installed RSL15 CMSIS-Pack. Admin rights are required to install and run onsemi-provided software, such as the onsemi IDE and BLE Explorer.                                          "},"2":{y:0,u:"../Content/getting_started_rsl15/gs_RSLCentral_LP.htm",l:-1,t:"Using RSL Central Mobile App to Establish a Bluetooth Low Energy Connection",i:0.00298346005075112,a:"The RSL15 Evaluation and Development Board (EVB) comes programmed with the ble_peripheral_server sample, enabling it to establish a Bluetooth Low Energy connection with the RSL Central  Android / iOS  app. Your RSL15 EVB must have the ble_peripheral_server sample loaded to connect to the\nRSL Central mobile app. If the ble_perhipheral_server code is modified or removed, it can be restored by following \nthe instructions in this guide to load the blinky sample app with your preferred IDE, but load the ble_peripheral_server sample instead.\n The \n\n RSL Central app scans and establishes a Bluetooth Low Energy connection with the RSL15 EVB. After establishing the connection, the app displays the battery level and button state (SW1) from the RSL15 EVB in real-time. It can also control the LED state on the RSL15 EVB by toggling the LED switch in the app. \nSimply power the RSL15 EVB by connecting the USB cable and use the RSL Central app to connect. Then use the app to:     Scan for available ..."},"3":{y:0,u:"../Content/getting_started_rsl15/gs_ConnectHW_LP.htm",l:-1,t:"Setting Up the RSL15 Evaluation and Development Board",i:0.000447713649571742,a:"Setting Up the RSL15 Evaluation and Development Board This topic shows how to set up the RSL15 Evaluation and Development Board (EVB) to get started. For more information about this topic, see:"},"4":{y:0,u:"../Content/getting_started_rsl15/gs_ConnectHW_Connecting.htm",l:-1,t:"Configuring and Connecting Hardware",i:0.00298346005075112,a:"Configuring and Connecting Hardware Verify that the RSL15 EVB has the default jumper configuration, which is VBAT and VOUT pins jumpered on the VBAT-SEL header, and VBAT and VDDO pins jumpered on the VDDO-EN header. See the  \"EVB with Default Jumper Configuration\" figure . The red boxes indicate default jumper positions. EVB with Default Jumper Configuration Once the jumpers are in the correct positions, you can plug the USB cable into the EVB. When powered, the blue LED flashes rapidly (it flashes slower when connected to the RSL Central mobile app). See the RSL15 Evaluation and Development Board User\u0027s Guide for more power options available for the RSL15 EVB."},"5":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_LP.htm",l:-1,t:"Getting Started with the onsemi IDE",i:0.000447713649571742,a:"Getting Started with the onsemi IDE This topic takes you through the steps for installing and setting up the onsemi IDE and the RSL15 CMSIS-Pack, importing and building sample code, and debugging your first application. For more information about this topic, see:"},"6":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_Software.htm",l:-1,t:"Software to Download",i:0.000447713649571742,a:"Software to Download  From  www.onsemi.com/RSL15 , download: The onsemi IDE Installer RSL15 Firmware Package which contains the RSL15 CMSIS-Pack and Release Notes."},"7":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_InstallIDE.htm",l:-1,t:"onsemi IDE Installation Procedure",i:0.000447713649571742,a:"onsemi IDE Installation Procedure The onsemi IDE installer comes bundled with the SEGGER® J-Link® installer..  For instructions on installing the onsemi IDE, and details on the J-Link version required for RSL15, see onsemi_IDE_release_notes.pdf in the ONSEMI IDE INSTALLER folder of the unzipped onsemi IDE Installer download, available at  www.onsemi.com/rsl15 ."},"8":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_PackInstallation.htm",l:-1,t:"RSL15 CMSIS-Pack Installation Procedure",i:0.00298346005075112,a:"Extract the RSL15 Firmware package to a temporary folder. Create a new workspace at, for example, C:\\workspace, using the onsemi Launcher, by following these steps:  Open the onsemi IDE by going to the Windows Start menu and selecting onsemi \u003e onsemi IDE. From the onsemi IDE Launcher screen, edit the suggested workspace name to a new name if needed, and click Launch. We recommend creating a new workspace for each new version of the IDE to ensure compatibility. On the top row of the Workbench perspective, click the \"Make the CMSIS Packs manager perspective visible\" icon. (See the  \"Opening the CMSIS-Pack Manager Perspective\" figure .) If you have trouble opening the CMSIS-Pack manager perspective, re-install the IDE in your user folder (i.e., C:\\Users\\\u003cuser_name\u003e). Opening the CMSIS-Pack Manager Perspective Click the Import Existing Packs icon, select your pack file (ONSemiconductor.RSL15.\u003cversion\u003e.pack), where \u003cversion\u003e is a number such as 1.0.0-464, and click Open. (See the  ..."},"9":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_ImportSampleCode.htm",l:-1,t:"Importing the Sample code",i:0.00298346005075112,a:"Import the sample as follows: In the Pack Manager perspective, click on the Examples tab to list all the example projects included in the RSL15 CMSIS-Pack. (See the  \"Pack Manager Perspective: Examples Tab\" figure .) Choose the example project called Blinky, and click the Copy button to import it into your workspace. When the confirmation window appears, choose Copy. Pack Manager Perspective: Examples Tab The C/C++ perspective opens and displays your newly copied project. In the Project Explorer panel, you can expand your project folder and explore the files inside your project. Double-click on the file names to open them. In the Components view, the blinky.rteconfig file displays software components. If you expand Device \u003e Libraries in the Components view, you can see the HAL library and the Startup components selected for blinky. (See the  \"RTE Configuration for the Blinky Example Project in the onsemi IDE\" figure .) RTE Configuration for the Blinky Example Project in the onsemi IDE"},"10":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_BuildSampleCode.htm",l:-1,t:"Building the Sample Code",i:0.00298346005075112,a:"Follow these steps to build the sample code: In the Project Explorer view, right click on the folder for blinky and click Build Project. Alternatively, you can select the project and click the Build Project icon, which looks like a hammer, as shown in the  \"Beginning to Build a Project in the onsemi IDE\" figure . Beginning to Build a Project in the onsemi IDE When the build is running, the output of the build is shown in the onsemi IDE C/C++ Development Tooling (CDT) Build Console, as illustrated in the  \"Example of Build Output\" figure . Example of Build Output The key resulting output in Project Explorer, in the Debug folder, includes: blinky.hex: hex file for loading into flash memory blinky.elf: Arm® executable file, run from RAM, used for debugging blinky.map: map file of the sections and memory usage These files are shown in the  \"Output Files from Building a Sample Project\" figure . You might need to refresh the project to see the three built output files. To do so, right-click ..."},"11":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_DebugSampleCode.htm",l:-1,t:"Debugging the Sample Code",i:0.00416282450266307,a:"Debugging the Sample Code Debug the application as follows: From the Launch Configuration dropdown menu, select blinky Debug. From the Launch Mode dropdown menu, select Debug.  Both are shown in the  \"Launching a Debug Session\" figure ).  Press the Launch in Debug button (also shown in the  \"Launching a Debug Session\" figure ) to launch the debug session.  J-Link downloads the blinky sample code to RSL15’s flash memory.  Launching a Debug Session The Debug perspective opens and the application runs up to the first breakpoint in main. Press F8 or click the Resume icon ( ) to resume the execution of the application. In the  RSL15 EVB, you can see that a green and a blue LED are both blinking, at different rates. When push-button SW1 is pressed, the blinking of these two LEDs is disabled or enabled.  "},"12":{y:0,u:"../Content/getting_started_rsl15/gs_onsemi_ViewPeriphReg.htm",l:-1,t:"Viewing Peripheral Registers with the onsemi IDE",i:0.00298346005075112,a:"The Peripheral Registers View Plugin The onsemi IDE includes a peripheral register view plugin that enables you to visualize and modify all of the RSL15 registers during a debug session. The following steps demonstrate how to use the Peripheral Registers View with the Blinky application: If you are not using a onsemi sample application, but one of your own instead, follow these steps to set the location of the system viewer description (SVD) file: Right click the program name, and choose Debug As \u003e Debug Configuration. In the resulting window, choose GDB SEGGER J-Link Debugging. Click on the name of the application you are working with. In the SVD Path tab, fill in the File Path box with the following: ${cmsis_pack_root}/ONSemiconductor/RSL15/\u003cversion\u003e/svd/rsl15.svd where \u003cversion\u003e is the CMSIS-Pack version number, and click Debug. (See the  \"Changing the SVD Path\" figure .) Changing the SVD Path In the Debug perspective, when the application runs up to the first breakpoint in main, ..."},"13":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_LP.htm",l:-1,t:"Getting Started with Keil®",i:0.000447713649571742,a:"Getting Started with Keil® This topic shows how you can set up and start using RSL15 with the Arm Keil μVision® IDE. For more information about this topic, see:"},"14":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_Software.htm",l:-1,t:"Software to Download",i:0.000447713649571742,a:"Software to Download Download the following: The Keil μVision IDE from  the Keil website . RSL15 Firmware Package, which contains the CMSIS-Pack and Release Notes, from  www.onsemi.com/rsl15 ."},"15":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_Installation.htm",l:-1,t:"Keil Installation Procedure",i:0.000447713649571742,a:"Keil Installation Procedure Follow the Keil μVision IDE installation instructions provided by Keil. After the Keil IDE is installed, you need to update the SEGGER J-Link software: Go the Start menu and type J-Link DLL Updater V\u003cJ-Link_version\u003e, where \u003cJ-Link_version\u003e is the version of J-Link recommended for the Keil μVision IDE, and press Enter. Select the Keil MDK-ARM checkbox and click OK. The RSL15 device is now available in the Keil IDE."},"16":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_InstallPack.htm",l:-1,t:"RSL15 CMSIS-Pack Installation Procedure",i:0.00298346005075112,a:"To install the RSL15 CMSIS-Pack: Extract the RSL15 Firmware package to a temporary folder Open the Keil μVision IDE and navigate to Project \u003e Manage \u003e Pack Installer or click on the icon shown in the  \"Pack Installer Icon\" figure . Pack Installer Icon Click on File \u003e Import (see the  \"Importing the RSL15 CMSIS-Pack\" figure ), select your pack file ONSemiconductor.RSL15.\u003cversion\u003e.pack, and click Open (see the  \"Installing the RSL15 CMSIS-Pack for the Keil μVision IDE\" figure ). \u003cversion\u003e is the RSL15 version, such as 2.2.347. Importing the RSL15 CMSIS-Pack Installing the RSL15 CMSIS-Pack for the Keil μVision IDE The IDE installs the RSL15 CMSIS-Pack in the %LOCALAPPDATA%\\Arm\\Packs folder. After installation, use File \u003e Refresh as shown in the  \"Refresh Pack after installation\" figure  to update your pack proprieties. Refresh Pack after installation The RSL15 CMSIS-Pack now appears in the list of installed packs. In the Devices tab, if you expand All Devices \u003e ONSemiconductor \u003e  RSL15 ..."},"17":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_ImportSampleCode.htm",l:-1,t:"Importing the Sample Code",i:0.00298346005075112,a:"Importing the Sample Code To import the sample code: In the Pack installer, click on the Examples tab to list all the example projects included in the RSL15 CMSIS-Pack. Choose the example project called blinky, and click the Copy button to import it into your workspace (see the  \"Pack Manager Perspective: Examples Tab\" figure ). Choose a destination folder for a copy of the sample code. We recommend leaving the Launch μVision checkbox checked. Pack Manager Perspective: Examples Tab For the blinky sample, the Startup, HAL and GPIO components are preconfigured with the source variant, so the source code of these libraries is included directly (see the  \"RTE Configuration for the Blinky Example Project in the Keil μVision IDE\" figure ). RTE Configuration for the Blinky Example Project in the Keil μVision IDE"},"18":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_BuildSampleCode.htm",l:-1,t:"Building the Sample Code",i:0.00298346005075112,a:"Building the Sample Code Build the sample code as follows: Right click on RSL15 and choose Rebuild all target files. Alternatively, you can use the icon shown in the  \"Starting to Build a Project in the Keil μVision IDE\" figure . Compiling with Link-Time Optimization (LTO) enabled might result in some unexpected results. For more information on LTO, see  this LTO article in the Arm Community website . Starting to Build a Project in the Keil μVision IDE When the build is running, the output of the build is shown in the Build Output view in the IDE, as illustrated in the  \"Example of Build Output\" figure . Example of Build Output The key resulting output in Project Explorer in the IDE includes: blinky.hex: HEX file for loading into Flash memory blinky.axf: Arm executable file, run from RAM, used for debugging blinky.map: map file of the sections and memory usage"},"19":{y:0,u:"../Content/getting_started_rsl15/gs_Keil_DebugSampleCode.htm",l:-1,t:"Debugging the Sample Code",i:0.00298346005075112,a:"Preparing J-Link for Debugging Before debugging with J-Link, go to C:\\Keil_v5\\ARM\\Segger and make sure that the folder contains a JL2CM3.dll file. As well, make sure that you have installed a compatible version of J-Link. Debugging Applications The IDE’s debug configurations are already set in the CMSIS-Pack. To debug an application: Make sure the EVB is connected to the PC via a USB cable. Select Debug \u003e Start/Stop Debug Session or click the icon shown in the  \"Start/Stop Debug Session Icon\" figure . Start/Stop Debug Session Icon The application runs up to the first breakpoint in main, as shown in the  \"Debug Session in the Keil μVision IDE\" figure . You can press F11 multiple times to step through the code and observe that the LED changes its state when the application executes the line gpio-\u003eToggleValue(TIMER0_STATES_GPIO).   .   Debug Session in the Keil μVision IDE Debug configurations are preconfigured for the sample applications in the CMSIS-Pack. Flash downloading through the ..."},"20":{y:0,u:"../Content/getting_started_rsl15/gs_IAR_LP.htm",l:-1,t:"Getting Started with IAR",i:0.000447713649571742,a:"Getting Started with IAR This topic shows how you can set up and start using RSL15 with the IAR Embedded Workbench® IDE from IAR Systems®. For more information about this topic, see:"},"21":{y:0,u:"../Content/getting_started_rsl15/gs_IAR_PrereqSW.htm",l:-1,t:"Prerequisite Software: Downloading and Installation",i:0.000447713649571742,a:"Prerequisite Software: Downloading and Installation Download and install the IAR Embedded Workbench from the  IAR Systems Website , using the vendor’s instructions. After the IAR IDE is installed, you need to update the SEGGER® J-Link® software:  Go the Start menu and type J-Link DLL Updater V\u003cJ-Link_version\u003e, where \u003cJ-Link_version\u003e is the version of J-Link recommendeded for the IAR Embedded Workbench, and press Enter. Select the IAR Embedded Workbench for ARM checkbox and click OK. Download the RSL15 Software Package from  www.onsemi.com/RSL15  and extract the RSL15 CMSIS-Pack (onsemi.RSL15.\u003cversion\u003e.pack) to any temporary folder."},"22":{y:0,u:"../Content/getting_started_rsl15/gs_IAR_Install.htm",l:-1,t:"RSL15 CMSIS-Pack Installation Procedure",i:0.00298346005075112,a:"To install the RSL15 CMSIS-Pack: Open the IAR Embedded Workbench and expand File \u003e New Workspace to open a new workspace, then go to File \u003e Save Workspace As and choose the location for your workspace. Navigate to Project \u003e CMSIS Pack Manager, or click on the icon shown in the  \"Pack Installer Icon\" figure . Pack Installer Icon Click on CMSIS Manager \u003e Import Existing Packs, select your pack file ONSemiconductor.RSL15.\u003cversion\u003e.pack, and click Open (see the  \"Installing the RSL15 CMSIS_Pack for the IAR Embedded Workbench IDE\" figure ). \u003cversion\u003e is the RSL15 version. Installing the RSL15 CMSIS_Pack for the IAR Embedded Workbench IDE The IDE prompts you to read and accept the license agreement, then installs the RSL15 CMSIS-Pack in the CMSIS-Pack root folder. After installation, click on the refresh icon with yellow arrows, which shows the text Reload Packs in the CMSIS Pack root folder when you hover over it with your cursor, in the Packs tab (as shown in the  \"Refresh Pack after ..."},"23":{y:0,u:"../Content/getting_started_rsl15/gs_IAR_BuildFirstApp.htm",l:-1,t:"Building Your First Sample Application with the IAR Embedded Workbench",i:0.00298346005075112,a:"This section guides you through importing and building your first sample application, named blinky. This application makes the LED (DIO6) blink on the RSL15 Evaluation and Development Board. The procedure described in this section assumes that you have installed the SDK. For more information about the sample applications, see the readme files accompanying the code. Import the Sample Code Import the sample code to your workspace as follows: In the IDE’s CMSIS Manager, click on the Examples tab to list all the example projects included in the RSL15 CMSIS-Pack. Choose the example project called blinky, and click the Copy button to import it into your workspace (see the  \"IAR Embedded Workbench CMSIS Manager: Examples Tab\" figure ). Choose a destination folder for a copy of the sample code. IAR Embedded Workbench CMSIS Manager: Examples Tab For the blinky sample, the Startup, HAL and GPIO components are preconfigured with the source variant, so the source code of these libraries is ..."},"24":{y:0,u:"../Content/getting_started_rsl15/gs_ResolveDeps_LP.htm",l:-1,t:"Resolving External CMSIS-Pack Dependencies",i:0.000447713649571742,a:"Resolving External CMSIS-Pack Dependencies This topic explains CMSIS-Pack dependencies, and how to resolve them so that \"component is missing\" errors are avoided when importing sample code from the RSL15 CMSIS-Pack into the workspace. For more information about this topic, see:"},"25":{y:0,u:"../Content/getting_started_rsl15/gs_ResolveDeps_ExternalDeps.htm",l:-1,t:"External CMSIS_Pack Dependencies",i:0.000447713649571742,a:"External CMSIS_Pack Dependencies Some of the RSL15 sample applications depend on software components from external vendors. For example, \napplications that make use of CMSIS-Drivers or FreeRTOS depend on CMSIS-Packs provided by Arm. The \ndependencies are displayed in the RTE Configuration. See  Resolving External Dependencies  for an example."},"26":{y:0,u:"../Content/getting_started_rsl15/gs_ResolveDeps_ResExtDeps.htm",l:-1,t:"Resolving External Dependencies",i:0.0055192064519305,a:"The following instructions show how to identify and resolve external dependencies in RSL15 sample \napplications using the CMSIS-Pack manager. RTE Configuration Perspective Before Resolving Pack Dependencies The  \"RTE Configuration Perspective Before Resolving Pack Dependencies\" figure  shows the RTE Configuration view when Pack dependencies are unresolved. To resolve Pack \ndependencies, follow these steps: In the CMSIS-Pack Manager perspective, click on the Check for Updates on Web button (see the  \"Check for Updates on Web Button\" figure ). Check for Updates on Web Button The  \"Installing the Arm CMSIS-Pack\" figure  shows an example of the Packs tab after checking for updates. Installing the Arm CMSIS-Pack To manually install a CMSIS-Pack, select the Packs tab and search for the required CMSIS-Pack (in this \nexample, we installed the ARM.CMSIS pack); click the Install button (shown in the  \"Installing the Arm CMSIS-Pack\" figure ). Alternatively, \nfollow the next steps to automatically ..."},"27":{y:0,u:"../Content/getting_started_rsl15/gs_AccessDoc_LP.htm",l:-1,t:"Accessing Documentation Included with the CMSIS-Pack",i:0.000447713649571742,a:"Accessing Documentation Included with the  CMSIS-Pack Documentation is included in the CMSIS-Pack, and is found in the \\documentation folder at your RSL15 install location, C:\\Users\\\u003cuser_id\u003e\\AppData\\Local\\Arm\\Packs\\ONSemiconductor\\RSL15\\\u003cversion\u003e\\, where \u003cuser_id\u003e is your userid on your system and \u003cversion\u003e is the RSL15 version number. The documentation can be accessed directly from an IDE. For information about how to access documentation through your IDE, see:"},"28":{y:0,u:"../Content/getting_started_rsl15/gs_AccessDoc_onsemiIDE.htm",l:-1,t:"Accessing Documentation through the onsemi IDE",i:0.00298346005075112,a:"Accessing Documentation through the onsemi IDE To access the documentation via the onsemi IDE, follow these steps: From the C/C++ perspective, open  any RTE configuration file, such as blinky.rteconfig (see the  \"Opening the .rteconfig file in the onsemi IDE\" figure ). Opening the .rteconfig file in the onsemi IDE Select the Device tab (see the  \"Accessing Documentation with the Device Tab\" figure ).  Accessing Documentation with the Device Tab From this list you can open the documentation files, which are marked with green book icons."},"29":{y:0,u:"../Content/getting_started_rsl15/gs_AccessDoc_KeilIDE.htm",l:-1,t:"Accessing Documentation via the Keil μVision IDE",i:0.00298346005075112,a:"Accessing Documentation via the Keil μVision IDE To open component-specific documentation in Keil μVision, you first need to click on the Manage Run-Time Environment icon (see the  \"Accessing Documentation via the Keil μVision IDE\" figure ). Keil’s Mange Run-Time Environment Icon Next, select the software component you are interested in (such as the Startup component chosen in the  \"Keil μVision Run-TIme Environment\" figure ). Keil μVision Run-TIme Environment Documentation can be opened by navigating to View \u003e Open Books Window, or to Help \u003e Open Books Window (see the  \"Keil Books Window Showing Documentation\" figure ). Keil Books Window Showing Documentation From this list you can open the documentation files, which are marked with green book icons."},"30":{y:0,u:"../Content/developers_guide_rsl15/dg_LandingPage.htm",l:-1,t:"RSL15 Developer’s Guide",i:0.000447713649571742,a:"RSL15 Developer’s Guide The  RSL15 Developer\u0027s Guideis for those who are designing software and firmware to run on RSL15. This group of topics serves as a guide for creating your own applications, based on samples or from scratch, and offers tips, tricks and best practices for developing with RSL15. This group of topics is intended to be used in conjunction with the RSL15 Firmware Reference, RSL15 Hardware Reference, and the provided third-party documentation, after a user has completed the startup steps outlined in the RSL15 Getting Started Guide.                                            "},"31":{y:0,u:"../Content/developers_guide_rsl15/dg_BlinkyToBuild_LP.htm",l:-1,t:"From Blinky to Building Your Own Application",i:0.000447713649571742,a:"From Blinky to Building Your Own Application Following this recommended progression with the SDK allows you to quickly become familiar with the software environment and learn to navigate, execute and modify the sample code with the ultimate goal of using the tools to build your own application.\n For more information about this topic, see:"},"32":{y:0,u:"../Content/developers_guide_rsl15/dg_BlinkyToBuild_Progression.htm",l:-1,t:"Progression",i:0.000447713649571742,a:"\nThe sample code offers many single-topic samples to enable you to learn about and develop one function or feature at a time in isolation. Once you are comfortable, you can work your way up to full-featured integrated samples, applying techniques you have learned from using the single function samples. \n\nThe progression from the simplest sample application to the most integrated application is: \n Blinky: following the RSL15 Getting Started Guide to install the tools and execute blinky.  Single function samples: build and execute samples such as sleep, uart or SPI and experiment with configurations for your end application.  Wireless samples: build and execute samples such as ble_peripheral_server to experiment with a wireless Bluetooth Low Energy connection and develop configurations for your application.  Integrated samples: build and execute samples such as ble_peripheral_server_sleep and ble_peripheral_server_sleep_fota to learn interactions of a complete system.  See  How to Build ..."},"33":{y:0,u:"../Content/developers_guide_rsl15/dg_CMSIScomponents_LP.htm",l:-1,t:"RSL15 CMSIS-Pack Component Description",i:0.000447713649571742,a:"RSL15 CMSIS-Pack Component Description This topic explains key concepts about the structure of the RSL15 CMSIS-Pack, its relationship to the project workspace, and methods for modifying linked files when necessary. For more information about this topic, see:"},"34":{y:0,u:"../Content/developers_guide_rsl15/dg_CMSIScomponents_FileStructure.htm",l:-1,t:"The RSL15 CMSIS-Pack Component Structure",i:0.00298346005075112,a:"Introduction The CMSIS-Pack is a convenient method to package and deliver sample code. The structure of the pack, projects and workspaces allow for easy update when new packs are available. The  sample code project workspaces contain the application files, but not the system-level files.  The system-level files remain in the CMSIS-Pack, and are linked to the project workspaces.  This allows for easy updating of these linked system-level files when new packs are installed, without changing the user application code to which these files are linked. For most use cases, customers do not need to modify these linked system level files. What is a Component? A component is a group of files in the CMSIS-Pack that are relevant to a particular project. For example, the GPIO component in the blinky sample project consists of gpio_driver.c, gpio_driver.h and Driver_GPIO.h. This is shown in the  \"GPIO Component\" figure , which shows a list of the files in the GPIO component.   GPIO Component ..."},"35":{y:0,u:"../Content/developers_guide_rsl15/dg_CMSIScomponents_Modifying.htm",l:-1,t:"Modifying Linked System-Level Files",i:0.000447713649571742,a:"Modifying Linked System-Level Files     For most use cases, there is no need to modify the linked system-level files. However, if such modification is necessary, it can be done in either of two ways: \n        Modify the files directly in the RSL15 CMSIS-Pack. Be aware that any other project linking to the modified files is affected by your changes as well. \n        Copy the file to the workspace, and break the link to the CMSIS-Pack."},"36":{y:0,u:"../Content/developers_guide_rsl15/dg_BuildApp_LP.htm",l:-1,t:"How to Build Your Own RSL15 Application",i:0.00082828988299581,a:"How to Build Your Own RSL15 Application This group of topics outlines two different methods for building your own RSL15 application using the onsemi IDE. For more information about this topic, see:"},});