define({"37":{y:0,u:"../Content/developers_guide_rsl15/dg_BuildApp_Existing.htm",l:-1,t:"Option 1: Using the CMSIS-Pack Features to Build Your Own Application",i:0.00298346005075112,a:"The easiest way to build your first RSL15 application is to modify one of the existing sample applications that are part of the RSL15 CMSIS-Pack.  While this method has many steps, each step is simple and makes use of the CMSIS-Pack features to allow for ease development and ease of updating when new CMSIS-Packs are released by onsemi.  This is the applicable method for most users.  Advanced users can consider using an alternate option, described in  Option 1: Using the CMSIS-Pack Features to Build Your Own Application . Copying Application Code Files In the onsemi IDE, use the CMSIS-Pack Manager to copy an example that closely resembles your end application. The example used in this topic is the ble_peripheral_server_sleep application, as shown in the  \"Copying the Sample Application\" figure , but you can use the sample application that suits your purposes best. This process copies the application code to your workspace. (For more information about using the IDE and its Pack Manager, ..."},"38":{y:0,u:"../Content/developers_guide_rsl15/dg_BuildApp_Unzip.htm",l:-1,t:"Option 2: Unzip the CMSIS-Pack (Advanced Users)",i:0.000447713649571742,a:"Option 2: Unzip the CMSIS-Pack (Advanced Users) Advanced users might need to modify the linked library and system files to suit their needs. If so, they can take advantage of the fact that the CMSIS-Pack is a zip file with an xml descriptor (.pdsc file).  The CMSIS-Pack can simply be unzipped, independent of an IDE.  Then the files can be taken directly from the unzipped output and modified as necessary. When new CMSIS-Packs become available from onsemi, the updates need to be manually copied/merged."},"39":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_LP.htm",l:-1,t:"Diagnostic Strategies",i:0.00309409984962759,a:"Diagnostic Strategies This section explains some of the methods and tools available for testing, diagnosing and monitoring RSL15 applications. Good diagnostics and debugging generally starts with software best practices, such as modular code, coding standards and consistent well-placed comments. All attempts have been made to follow software best practices in the RSL15 SDK while offering other methods and tools to help quickly develop applications. For more information about this topic, see:"},"40":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_Breakpoints.htm",l:-1,t:"General Debugging Strategies",i:0.00298346005075112,a:"Breakpoints A useful way to inspect code operation is to insert breakpoints in a Debug session, or resume a stopped Debug session. By doing so, you can have the program execute to a given point and then halt, at which point you can examine variables, memory or other diagnostic data. To insert a breakpoint, double-click to the left of the line number on which you want to stop. See the  \"Setting a Breakpoint\" figure . Details on how to initiate a Debug session are provided in the  RSL15 Getting Started Guide. Setting a Breakpoint Breakpoints are a convenient method of checking that data at various stages is what you expect to see. With breakpoints, you can examine registers, variables and memory when debugging.  Debugging Best Practices One bug can sometimes hide another, so do not ignore bugs you find that are unrelated to the one you are actively trying to fix. Remember, if you fix another bug, be sure to go back and try to reproduce the first one again. When looking at problems with ..."},"41":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_swmTrace.htm",l:-1,t:"Printing to a Console with swmTrace",i:0.000638001766283776,a:"We generally recommend establishing a method to view the internals of an application early on in development (before problems arise) to ensure that everything is working as expected. Comparing console outputs between successful and failed outcomes can help pinpoint problems. The swmTrace module provides data printing capability and is described in the RSL15 Firmware Reference. It supports the commonly known printf() function to allow seamless printing to a PC console and a series of logging functions whose output characteristics are based on the logging level selected. The source code for swmTrace is available in the installation folder under firmware\\source\\lib\\swmTrace. There is also a sample application called swmTrace_logger, which demonstrates the usage of the swmTrace library. onsemi IDE Setup Requirements  newlib-nano is an open-source C library enabled in all sample applications. We strongly recommend that you enable it in the onsemi IDE when using swmTrace, by performing the ..."},"42":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_SleepMode.htm",l:-1,t:"Debugging with Sleep Mode",i:0.000447713649571742,a:"When an RSL15 device enters Sleep Mode or another low power mode, the device typically disables all digital elements including the debug port to minimize the system current of the device.  If the Arm Cortex-M3 processor processor is asleep but the overall system is not in Sleep Mode, the system can still transmit data or respond to a debugger. This common use case does not need special considerations.\n If a problem or system being debugged requires current measurements as part of the debug process, the debug port needs to be disabled. If this is required, the following mechanisms can function as potential debug tools: The swmTrace module, described in section  Printing to a Console with swmTrace , can be used to print data up to the point of sleeping and immediately after wakeup. The UART interface can be used both with and without the swmTrace module, to communicate data while not in Sleep Mode. Simple techniques, such as setting a GPIO high while in Sleep Mode and low when exiting, ..."},"43":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_Trustzone.htm",l:-1,t:"TrustZone Application Development and Debugging",i:0.000624731146927222,a:"TrustZone is a security hardware extension  that has been included with the Arm Cortex-M33 processor in the RSL15 device. This extension provides hardware isolation between secure and non-secure components, and can separate safe applications from unsafe ones, protecting underlying system components from being accessed or changed by untrusted code. For more information on the hardware support for TrustZone, see  TrustZone . When using TrustZone, the application is typically divided into two components, containing the secure and the non-secure application code respectively. System execution starts in the secure application component, which executes the non-secure application when necessary. The main loop for the application can exist in either the secure or the non-secure application component.  If the loop is in the non-secure application, no additional support is required.  If the loop is in the secure application, the secure application must re-initialize and start execution of the  ..."},"44":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_ActivityCtr.htm",l:-1,t:"Activity Counters",i:0.000447713649571742,a:"Activity Counters The Activity Counters are a set of hardware blocks used to accurately count cycles. The block can be used to profile system execution with the resolution of the system clock. It can easily be added to any code but keep in mind interrupts may vary the result. See the Activity Counters topic in the RSL15 Hardware Reference for more information."},"45":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_NotBaseFlash.htm",l:-1,t:"Debugging Applications that are Not Stored at the Base Address of Flash",i:0.000447713649571742,a:"If you want to debug an application that does not start at the first address of the flash memory (0x00100000), adjust your Debug Configuration on the Startup tab. See the  RSL15 Getting Started Guide for instructions on how to find this and the appropriate entry for the typical case of starting from the base of flash memory. The following example can be entered into the Run/Restart Commands field to execute an application at any location in memory: set {int} \u0026  VTOR = ISR_Vector_Table set $sp = *((int *) \u0026ISR_Vector_Table) set $pc = *((int *) (\u0026ISR_Vector_Table+4)) The linker configuration file (sections.ld) must match the start address used in the debug configuration. All user applications must include a vector table, and the vector table must be aligned to a 512-byte boundary. An example of when you might not want to start from the base address of flash is when you are using a bootloader that would typically be located at the base of flash. This is described in the readme file of the ..."},"46":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_FaultsAndErrors.htm",l:-1,t:"Strategies for Handling Application Errors",i:0.000447713649571742,a:"When an application error occurs, the device can end up in one of a few error states: The device could end up in a state where the firmware is stuck and the watchdog is not being refreshed, triggering a watchdog interrupt. The system could enter a state where a reset occurs due to one or more power supply issues. The system could encounter faults in the program execution due to program errors, erroneous execution, or access to secured resources when in the wrong system state.  The behavior of user applications when any of these kinds of errors occurs is important for the stability of end products. The RSL15 device provides a variety of information and resources for determining the causes of system errors, and we can recommend some top-level best practices for handling errors. However, the details of how your user application handles errors and error recovery is dependent on your application use cases. The following subsections discuss general best practices, and the information that ..."},"47":{y:0,u:"../Content/developers_guide_rsl15/dg_Debugging_3rdParty.htm",l:-1,t:"Third-party tools\n",i:0.000447713649571742,a:"Third-party tools\n SEGGER SystemView is a third-party tool available from SEGGER. It provides hooks for tracking and analyzing events that happen during runtime and can be used with RSL15 to provide diagnostics and visibility into your program execution. See  https://www.segger.com/products/development-tools/systemview/  for details on its operation and to download the tool."},"48":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashVariants_LP.htm",l:-1,t:"RSL15 Flash Variants",i:0.000447713649571742,a:"RSL15 Flash Variants RSL15 flash variants include devices with two different flash memory configurations. In both cases, the RSL15 flash is divided into two flash arrays that can both be read from with equal efficiency for any application use cases (including both application code and application data). These flash arrays have the following characteristics: The flash code array is organized into  2048-byte sectors, which make it ideal for storing larger items or items that are static. The flash data array is organized into 256-byte sectors, which make it ideal for storing smaller items or items that may be updated. For more information about this topic, see:"},"49":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashVariants_AvailableVariants.htm",l:-1,t:"Available Flash Variants with RSL15",i:0.00298346005075112,a:"The available RSL15 flash variants are: RSL15 (RSL15-512)  This variant provides 512 KB of flash memory, divided into a code flash array of 352 KB and a data flash array of 160 KB. This is the default RSL15 variant, and all sample applications and device configuration is configured to work with this variant by default.  When debugging code running on this variant, specify RSL15 as the device name on the debugger tab of the debug configuration. RSL15-284: This variant provides 284 KB of flash memory, divided into a code flash array of 264 KB and a data flash array of 20 KB. This variant uses different build configurations that are appropriate for the reduced memory layout. To configure the tools for use with this variant, see  Available Flash Variants with RSL15 . When debugging code running on this variant, specify RSL15-284 as the device name on the debugger tab of the debug configuration. Debugging an application built and configured for RSL15-284 on an RSL15-512 device functions ..."},"50":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashVariants_BuildAppRSL15-284.htm",l:-1,t:"Building an Application for an RSL15-284 Device",i:0.00298346005075112,a:"To build an application for an RSL15-284 device, a user needs to: Select the RSL15-284 device.  Clone the RTE_Device.h information provided for RSL15-512 devices into the RSL15-284 information folder Right click on the project, go to Properties \u003e C/C++ Build \u003e Settings \u003e Tool Settings \u003e Cross C Linker \u003e General and change the path from ${workspace_loc:/${ProjName}}/RTE/Device/RSL15/sections.ld to ${workspace_loc:/${ProjName}}/RTE/Device/RSL15-284/sections.ld. For the onsemi IDE, selecting the device can be done from the \u003capp\u003e.rteconfig file editor,  Devicetab,  Changeinterface screen as shown in the  \"Selecting the RSL15-284 Device\" figure , and cloning the RTE_Device.h information copies files from one directory to another as shown in the  \"Cloning the RTE_Device.h Configuration\" figure . Selecting the RSL15-284 Device Cloning the RTE_Device.h Configuration For the Keil µVision IDE, selecting the device can be done from the Device tab of the \"Options for Target \u0027RSL15\u0027...\" menu as ..."},"51":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashVariants_RSL15Packages.htm",l:-1,t:"RSL15 Packages",i:0.000447713649571742,a:"RSL15 Packages The RSL15 device contains 16 general purpose input/output (GPIO) pads. However, some RSL15 package variants do not have access to all 16 GPIO pads. Refer to your product datasheet for information about which GPIOs are externally accessible."},"52":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashvsRAM_LP.htm",l:-1,t:"Running from Flash vs Running from RAM",i:0.000447713649571742,a:"Running from Flash vs Running from RAM  Data that is meant to be written to flash cannot be read from flash while the flash programming interface is open. If an application loads a value from flash to a register, then completes a write on a single word and closes the flash programming interface before reading the next word, everything works fine. But in sequential writes, the system cannot close the flash programming interface between loads. The next value has to be loaded right away, and if that next value is located in flash, the process fails because the flash programming interface is open. Running from RAM is a way to keep this from happening. For more information about this topic, see:"},"53":{y:0,u:"../Content/developers_guide_rsl15/dg_FlashvsRAM.htm",l:-1,t:"Flash vs. RAM in Sample Applications",i:0.00298346005075112,a:"Several of the sample applications in the CMSIS-Pack have sequential writes and need to run from RAM. The ones that run from flash use the sections.ld linker script, as shown in  Applications Running from Flash . To run from RAM, the use of the sections_ram.ld linker script is required, as seen in  Applications Running from RAM . Applications Running from Flash The sample applications that run from flash automatically point to the sections.ld linker script. To see the pointer to the linker script, right-click on the Project folder or Alt + Enter \u003e Properties \u003e C/C++ Build \u003e Settings \u003e Cross Arm C Linker \u003e General settings: ${workspace_loc:/${\u003cproject_name\u003e}/RTE/Device/RSL15/sections.ld} Alternatively, you can copy the sections.ld file from the configuration folder in the CMSIS-Pack to the project, as in this example: ${cmsis_pack_root}/ONSemiconductor/RSL15/\u003cversion\u003e/firmware/configuration/GCC/sections.ld Applications Running from RAM The sample applications that run from RAM point by ..."},"54":{y:0,u:"../Content/developers_guide_rsl15/dg_Toolchain_LP.htm",l:-1,t:"Arm Toolchain Support",i:0.000447713649571742,a:"Arm Toolchain Support There are several ways in which the onsemi IDE determines which Arm® GNU toolchain to use when building. Understanding how this works can help prevent confusion and frustration when the development machine has several versions of GNU toolchains installed. For more information about this topic, see:"},"55":{y:0,u:"../Content/developers_guide_rsl15/dg_Toolchain_ToolchainSup.htm",l:-1,t:"Basic Installation",i:0.000447713649571742,a:"Basic Installation The onsemi IDE supports the Arm toolchain by installing it in the arm_tools directory within the installed IDE location. The build tools RM and Make are also included with the toolchain, to allow for an easier building experience out of the box. When the user starts the onsemi IDE with the IDE.exe program (whose shortcut is located in Windows menu items), the arm_tools\\bin directory is added to the path, to give the onsemi IDE access to the toolchain installed with the RSL15 software tools. Conflicts with toolchain versions can occur in the onsemi IDE, if an Arm-based toolchain has been installed elsewhere or already exists on the path, and the IDE selects that toolchain rather than the one included in arm_tools."},"56":{y:0,u:"../Content/developers_guide_rsl15/dg_Toolchain_ConfigArmTC.htm",l:-1,t:"Configuring the Arm Toolchain in the onsemi IDE",i:0.000447713649571742,a:"Configuring the Arm Toolchain in the onsemi IDE All toolchain location options can be accessed by right clicking on the project in the Project Explorer view, selecting Properties at the bottom of the pop-up menu, and choosing the C/C++Build \u003e Settings \u003e Toolchains tab. The scope of the toolchain path support is described below. Global Path: This is the path used by all workspaces/projects. The global path can be set in the Toolchains tab of the project. Workspace Path: This is the path used by all projects in the current workspace. Project Path: This is the path used by the current project for its toolchain."},"57":{y:0,u:"../Content/developers_guide_rsl15/dg_Toolchain_AddlSettings.htm",l:-1,t:"Additional Settings",i:0.000447713649571742,a:"Additional Settings Additional settings (other than the toolchain paths) are located within the MCU preference. These are: The Build Tools path (global, workspace, project-based) for tools such as Make and RM The SEGGER J-Link path (global, workspace, project-based) for the location of the SEGGER J-Link executables. This replaces the Run/Debug string substitutions for J-Link previously used."},"58":{y:0,u:"../Content/developers_guide_rsl15/dg_Toolchain_FPU.htm",l:-1,t:"Floating Point Unit (FPU) Support",i:0.000447713649571742,a:"Floating Point Unit (FPU) Support The Arm Cortex-M33 processor has support for hardware floating point calculations. The SDK samples and libraries use floats. Therefore, the FPU is powered on whenever the device is in Run Mode. In low power modes, power to the FPU is appropriately adjusted for each mode, as follows: In Sleep Mode when core retention is disabled by the application firmware, the FPU is not powered, so firmware does not need power down the FPU. In Sleep Mode when core retention is enabled, firmware powers down the FPU before entering sleep, and powers up the FPU again on wakeup. In Standby Mode, the power consumption of the FPU is negligible, so it is left powered on."},"59":{y:0,u:"../Content/firmware_reference/fwref_LandingPage.htm",l:-1,t:"RSL15 Firmware Reference",i:0.000447713649571742,a:"This group of topics describes the firmware included in the RSL15 System-on-Chip (SoC). It includes descriptions, function listings, and usage examples to help you understand the firmware and its parts. The firmware described in this reference provides developers with a convenient software layer on which to build their applications. It is also responsible for system-level tasks such as booting the system and implementing portions of the security layer. The firmware consists of include files, macros, libraries, ROM code, and executables. This group of topics is intended for use by developers who are designing and implementing applications for the RSL15 System-on-Chip. Both novice and experienced developers can benefit. The descriptions and code examples can help novice users to learn the system, while experienced developers can go straight to the reference chapters that describe the available functions, macros, libraries and executables. These topics assume that the reader has a basic ..."},"60":{y:0,u:"../Content/firmware_reference/fwref_Overview_LP.htm",l:-1,t:"Firmware Overview",i:0.000447713649571742,a:"Firmware Overview RSL15 is supported by a set of firmware components that provide: A thin layer of support between the hardware and the developer. This firmware allows developers to focus on application development, reducing the number of details they  need to know about the underlying RSL15 hardware. A support layer for common complex run time operations frequently included in user applications Security and lifetime provisioning elements, which help support the security elements needed throughout a device’s lifecycle Wireless protocol support functionality for Bluetooth® Low Energy applications Manufacturing and debug support elements For more information about this topic, see:"},"61":{y:0,u:"../Content/firmware_reference/fwref_Overview_Intro.htm",l:-1,t:"Introduction",i:0.000447713649571742,a:"The system firmware provides hardware definitions and a hardware abstraction layer for common operations. These definitions and abstraction layer are easier to use and understand than low-level C or assembly code. The firmware components supporting common run time, debug, and manufacturing elements simplify incorporation of the device into a system throughout the development cycle. In addition, the security and wireless protocol firmware elements provide more advanced functionality, which can form the basis for applications developed to take advantage of the hardware that the RSL15 SoC provides. When multiple programmers are involved in development, using the firmware leads to increased consistency, which in turn leads to increased overall robustness and correctness of code. In some cases, depending on the particulars of the application, the firmware implementation might not be optimal; however, even in these situations, the firmware serves as an example and an advanced starting point ..."},"62":{y:0,u:"../Content/firmware_reference/fwref_Overview_DataTypes.htm",l:-1,t:"Supported Data Types",i:0.00298346005075112,a:"Supported Data Types The  \"RSL15 Supported Data Types\" table  shows the data types and their sizes as supported by the RSL15 firmware. All uint_t types are included under the stdint.h library."},"63":{y:0,u:"../Content/firmware_reference/fwref_Overview_Components.htm",l:-1,t:"Firmware Components",i:0.000447713649571742,a:"Firmware Components The firmware files consist of include files (denoted with .h extensions) and library binaries (denoted with .a extensions). Some libraries are also provided in source code format. Descriptions of the firmware components, and detailed API references, are provided in the remainder of this group of topics. Applications that use the libraries provided must: Include the associated firmware include file. Link against any dependencies of the desired library. Link against a version of the desired library. The Arm CryptoCell™-312 libraries are available in Release configuration. The event kernel support firmware and the Bluetooth Low Energy protocol stack are available as a library."},"64":{y:0,u:"../Content/firmware_reference/fwref_Overview_NamingConventions.htm",l:-1,t:"Firmware Naming Conventions",i:0.00298346005075112,a:"For clarity and ease of use, many firmware components follow several naming conventions for library functions and macros. These conventions are compatible with the CMSIS naming requirements. Macros (defined using a #define statement) use all capitals in the macro name. These macro names include an all-capital prefix indicating the library or other firmware element they are supporting (e.g., SYS_). If the macro supports a specific target component, this prefix is followed by the name of the component it supports. The rest of the macro name indicates the intended functionality of the macro. Inline and standard firmware functions  use camel-case function names (e.g., CalcPhaseCnt). All functions use a prefix to indicate which library provides the function (e.g., Sys_). The remainder of a function’s name indicates the block it affects and the function\u0027s intended functionality. Library Function Naming Convention (table)  lists the prefixes for each of the firmware libraries that use ..."},"65":{y:0,u:"../Content/firmware_reference/fwref_Overview_ResourceUsage.htm",l:-1,t:"Firmware Resource Usage",i:0.00298346005075112,a:"The firmware uses the Arm Cortex-M33 processor system stack. It expects that the Arm Cortex-M33 processor\u0027s stack pointer points to a valid stack that grows downward (i.e., decreasing memory addresses). Other system memory used by the system are listed in the  \"Reserved Resources\" table . Other system components (DMA channels, LSAD inputs, etc.) that are used by the firmware are noted in the documentation for the specific component. Some RSL15 product variants might have additional custom trim values stored in the NVR6 region. Sample codes in the SDK include the SYS_TRIM_LOAD_CUSTOM() macro function, which reads and applies those values. In detail, the SYS_TRIM_LOAD_CUSTOM() function reads the custom value of the DC-DC inductor charge current trim and the custom value of the XTAL 48 MHz oscillator trim, and loads them into corresponding registers (the ICH_TRIM field of the ACS_VCC_CTRL register, the RF_REG2E_XTAL_TRIM_XTAL_TRIM_INIT field of the RF_REG2E register, and the ..."},"66":{y:0,u:"../Content/firmware_reference/fwref_Overview_Versions.htm",l:-1,t:"Versions",i:0.00298346005075112,a:"Versions Version symbols are provided for each major firmware component. The version symbols can be used directly or indirectly to verify the version of the components being used to build an application. There are three types of version symbols available: Define A preprocessor define or set of defines containing the version information.  Symbolic A compiled symbol contained within a binary library Global Variable A global variable in memory containing the symbol As an example, the available version information for the flash library firmware component is listed in the  \"Example Firmware Versions - Flash Library\" table .  "},"67":{y:0,u:"../Content/firmware_reference/fwref_HWDefs_LP.htm",l:-1,t:"Hardware Definitions",i:0.000756884786920252,a:"Hardware definition files are integral to the system firmware. The hardware definitions apply a layer of data structures and address mappings to the underlying hardware, so that every control register, bit field in the system, memory, and interrupt vector is easily accessible from C and assembly code. This set of header files provides a system definition for the RSL15 SoC, including: Register and bit descriptions for registers accessible to the processor Memory maps for all of the memories and memory-mapped elements that are accessible to the processor Interrupt vector table descriptions for the processor Macros that support the Arm Cortex-M33 processor\u0027s basic core functionality The format and configuration of all of these support files conform to CMSIS compatibility requirements wherever possible.\nAs required by CMSIS, the hardware definitions are included by the top-level CMSIS include file ( rsl15.h) alongside the other CMSIS requirements. For more information about CMSIS, and this ..."},"68":{y:0,u:"../Content/firmware_reference/fwref_HWDefs_RegisterBitFieldDefs.htm",l:-1,t:"Register and Register Bit-Field Definitions",i:0.00298346005075112,a:"Using the hardware definition files allows you to refer to system components by C structures, assembly code, and preprocessor symbols instead of by addresses and bit fields. This greatly improves the readability, reliability and maintainability of your application code. The use of hardware definitions in an application also means that some hardware changes, such as changes to addresses or bit field values, are transparent to your application code. Hardware register descriptions for the Arm Cortex-M33 processor\u0027s private peripherals are provided by the CMSIS package from Arm. Hardware register descriptions for all other components, and bit settings that are appropriate for use with the hardware register descriptions for the private peripherals, are available in the following files: rsl15_hw.h: This generic include file selects the desired underlying header file appropriate to your hardware by using the  RSL15_CID definition. rsl15_hw_cid*.h: This include file is the header file that is ..."},"69":{y:0,u:"../Content/firmware_reference/fwref_HWDefs_MemoryMapDef.htm",l:-1,t:"Memory Map Definition",i:0.000447713649571742,a:"Memory Map Definition The  rsl15_map.h header file contains the specific memory map definitions that provide the locations of the following structures within the memory maps of the processor:\n Instruction and data bus memory structures System bus memory structures Peripheral bus memory-mapped control registers (including the base of control register groups for each system component) Private peripheral bus internal memory-mapped control registers System variables Calibration trim records For more information on the memory map and memory mapped elements accessible to the Arm Cortex-M33 processor,  see the  RSL15 Hardware Reference."},});