define({"667":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Power_Timing.htm",l:-1,t:"Timing",i:0.000568533869034493,a:"The RSL15 system performs a number of steps, following resets and on transitions to or from various power modes, to ensure that when entering into Run Mode the user application can properly use and configure (or reconfigure) various system components needed by the application. The following sub-sections discuss system timing for system startup (following a power-on reset), as well as for entering and exiting Sleep and Standby Modes.  Startup Timing Startup timing starts when a supply voltage is provided to the battery supply voltage (VBAT) and Digital Output Supply Voltage (VDDO). For more information on these power supply inputs, see Section 1.1 “Power Supply Inputs ” on page 1. A diagram showing the startup timing until the system reaches Run Mode is shown in the  \"Startup Timing\" figure .  Startup Timing Timing until a user application starts executes will differ from this diagram for a number of reasons, including: If the system is starting up following a full reset, delays ..."},"668":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_LP.htm",l:-1,t:"Memory",i:0.000447713649571742,a:"Memory The memory systems provided by the RSL15 system are constructed using a number of memories (memory instances), memory buses, memory controllers, and memory arbiters. These memories and other memory-mapped elements are addressable by the Arm Cortex-M33 processor and its peripherals. For more information about this topic, see:"},"669":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_Architecture.htm",l:-1,t:"Architecture",i:0.00761067845754951,a:"The RSL15 system uses a memory architecture based on the pre-defined memory map of the Arm Cortex-M33 processor.  The implementation of the memory architecture uses a number of single-port memories and memory-mapped registers interconnected with memory buses and support elements. All memories are accessible through the Arm Cortex-M33 possessor, although some interfaces and peripherals such as the DMA and Bluetooth baseband provide additional access paths to specific memory elements. The connections to the components that make up the memory for the RSL15 system are shown in the  \"System Memory Architecture\" figure . System Memory Architecture Memory Instances The memory architecture for RSL15, including the memory instances, registers, and other components, are accessible from the Arm Cortex-M33 processor through one or more of the processor’s standard buses. All the memory instances are shown in the  \"RSL15 Memory Instances\" table . RSL15 is produced in two variants with different ..."},"670":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_MemMapUsage.htm",l:-1,t:"Memory Map and Usage",i:0.000778670424020972,a:"The memory map provided for the RSL15 device follows the standard Arm Cortex-M33 processor memory layout. All memory instances and memory-mapped elements are accessible through this memory map, as shown in the  \"Default RSL15 Memory Map\" figure . Default RSL15 Memory Map The address ranges are in hexadecimal format. The following subsections provide a brief description and usage of each area. These areas are as follows: Program ROM, as described in the Program ROM Chapter of the  RSL15 Firmware Reference Manual Flash Memory Data RAM Other memory mapped areas Flash Memory RSL15 contains a flash memory instance that provides the following areas that can be written through the flash memory interface:  Code Flash An area of flash optimized for use as larger (2 KB) blocks of memory. This area is typically used to store program code. Data Flash An area of flash optimized for use as smaller (256 B) blocks of memory. This area is typically used to store static data or additional program code, ..."},"671":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_Flash.htm",l:-1,t:"Flash",i:0.00142300628358662,a:"The RSL15 device includes a flash memory instance for use as non-volatile memory. The topics that follow describe its characteristics and use. Flash Characteristics The flash memory instance contains: A main flash area consisting of two flash arrays: For RSL15-512 devices, this flash memory provides 512 KB of flash memory divided into a code flash array of 352 KB and a data flash array of 160 KB. For RSL15-284 devices, this flash memory provides 284 KB of flash memory divided into a code flash array of 264 KB and a data flash array of 20 KB. The code flash array is organized into 2048-byte sectors; the data flash array is organized into 256-byte sectors. Both arrays are accessed using the same memory buses, so it is equally efficient to execute code or access data stored to either array. Eight non-volatile records (NVR), each consisting of one flash sector of 256 bytes One manufacturing non-volatile record (MNVR), consisting of one flash sector that contains two copies of the 128 bytes ..."},"672":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_FlashReg.htm",l:-1,t:"Flash Memory Registers",i:0.000850932825667174,a:"Flash Memory Registers"},"673":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_IF_CTRL.htm",l:-1,t:"FLASH_IF_CTRL",i:0.000485784704856514,a:"FLASH_IF_CTRL Bit Field Field Name Value Symbol Value Description Hex Value 16 NOT_LOAD_AUTO FLASH_LOAD_AUTO_ENABLE No automatic load done after the WAKEUP command  0x0* FLASH_LOAD_AUTO_DISABLE The CMD_WAKEUP includes the loading of internal registers and patch information.  0x1 12 VREAD1_MODE FLASH_VREAD1_DISABLE After erase, read data with a normal condition  0x0* FLASH_VREAD1_ENABLE After erase, read data with a more stringent condition  0x1 10 RECALL FLASH_RECALL_DISABLE RECALL pin low during read command  0x0* FLASH_RECALL_ENABLE RECALL pin high during read command  0x1 9:8 RETRY FLASH_RETRY_1 for 1st erase pulse  0x0* FLASH_RETRY_2 for 2nd erase pulse  0x1 FLASH_RETRY_3 for 3rd erase pulse  0x2 FLASH_RETRY_4 for 4th erase pulse or required during programming  0x3 0 LP_MODE FLASH_LOW_POWER_DISABLE Disable the Flash low power mode  0x0* FLASH_LOW_POWER_ENABLE Enable the Flash low power mode  0x1"},"674":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_MAIN_WRITE_UNLOCK.htm",l:-1,t:"FLASH_MAIN_WRITE_UNLOCK",i:0.000485784704856514,a:"FLASH_MAIN_WRITE_UNLOCK Bit Field Field Name Value Symbol Value Description Hex Value 31:0 UNLOCK_KEY FLASH_MAIN_KEY 32-bit key to allow for Read and Write accesses into the Flash MAIN Block  0xDBC8264E"},"675":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_MAIN_CTRL.htm",l:-1,t:"FLASH_MAIN_CTRL",i:0.000485784704856514,a:"Bit Field Field Name Value Symbol Value Description Hex Value 11 DATA_A_35K_TO_40K_W_EN DATA_A_35K_TO_40K_W_DISABLE The part K to K of the Flash MAIN Data array is protected against write access  0x0* DATA_A_35K_TO_40K_W_ENABLE The part K to K of the Flash MAIN Data array can be written  0x1 10 DATA_A_30K_TO_35K_W_EN DATA_A_30K_TO_35K_W_DISABLE The part K to K of the Flash MAIN Data array is protected against write access  0x0* DATA_A_30K_TO_35K_W_ENABLE The part K to K of the Flash MAIN Data array can be written  0x1 9 DATA_A_25K_TO_30K_W_EN DATA_A_25K_TO_30K_W_DISABLE The part K to K of the Flash MAIN Data array is protected against write access  0x0* DATA_A_25K_TO_30K_W_ENABLE The part K to K of the Flash MAIN Data array can be written  0x1 8 DATA_A_20K_TO_25K_W_EN DATA_A_20K_TO_25K_W_DISABLE The part K to K of the Flash MAIN Data array is protected against write access  0x0* DATA_A_20K_TO_25K_W_ENABLE The part K to K of the Flash MAIN Data array can be written  0x1 7 ..."},"676":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_DELAY_CTRL.htm",l:-1,t:"FLASH_DELAY_CTRL",i:0.000485784704856514,a:"FLASH_DELAY_CTRL Bit Field Field Name Value Symbol Value Description Hex Value 7 READ_MARGIN DEFAULT_READ_MARGIN Use default read margins  0x0* FAST_READ_MARGIN Use fast read margins  0x1 3:0 SYSCLK_FREQ FLASH_DELAY_FOR_SYSCLK_3MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 3 MHz  0x0 FLASH_DELAY_FOR_SYSCLK_4MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 4 MHz  0x1 FLASH_DELAY_FOR_SYSCLK_5MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 5 MHz  0x2* FLASH_DELAY_FOR_SYSCLK_8MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 8 MHz  0x3 FLASH_DELAY_FOR_SYSCLK_10MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 10 MHz  0x4 FLASH_DELAY_FOR_SYSCLK_12MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 12 MHz  0x5 FLASH_DELAY_FOR_SYSCLK_16MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 16 MHz  0x6 FLASH_DELAY_FOR_SYSCLK_20MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 20 MHz  0x7 FLASH_DELAY_FOR_SYSCLK_24MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 24 MHz  0x8 FLASH_DELAY_FOR_SYSCLK_48MHZ FLASH_DELAY_CTRLx set for a SYSCLK = 48 MHz  0x9"},"677":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_CMD_CTRL.htm",l:-1,t:"FLASH_CMD_CTRL",i:0.000485784704856514,a:"Bit Field Field Name Value Symbol Value Description Hex Value 5 CMD_END CMD_END Terminates an active Flash command if possible  0x1 4:0 COMMAND CMD_IDLE Idle command  0x0* CMD_WAKE_UP Wake up the Flash  0x1 CMD_LOAD_TRIM Load patch and trimming values from MNVR  0x2 CMD_READ Execute a read cycle  0x5 CMD_PROGRAM_NOSEQ Execute a non-sequential programming cycle  0x6 CMD_PROGRAM_SEQ Starts a sequential programming sequence  0x7 CMD_SECTOR_ERASE Execute a sector erase cycle  0x8 CMD_MASS_ERASE Execute a mass erase cycle  0x9 CMD_SET_LOW_POWER Wait time to set the LPWR pin  0xA CMD_UNSET_LOW_POWER Wait time to unset the LPWR pin  0xB CMD_SET_RECALL Wait time to set the RECALL pin  0xC CMD_UNSET_RECALL Wait time to unset the RECALL pin  0xD CMD_SET_VREAD1 Wait time to set the VREAD1 pin  0xE CMD_UNSET_VREAD1 Wait time to unset the VREAD1 pin  0xF CMD_WRITE_USER_RED Write FLASH_DATA to PATCH4 of M NVR, FLASH_DATA[1] indicates which redundancy sector, FLASH_DATA[0] the data to write  0x10 ..."},"678":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_IF_STATUS.htm",l:-1,t:"FLASH_IF_STATUS",i:0.000485784704856514,a:"Bit Field Field Name Value Symbol Value Description Hex Value 31 TRIMMED_STATUS FLASH_UNTRIMMED All MNVR CBD0-CDB7 contents are equal to 0xFFFF. Flash untrimmed.  0x0* FLASH_TRIMMED Some registers CBD0-CBD7 contents are not equal to 0xFFFF. Flash trimmed.  0x1 30 ISOLATE_STATUS FLASH_ACCESSIBLE Flash can be accessed (isolation inactive)  0x0 FLASH_ISOLATE Flash cannot be accessed (isolation active)  0x1* 29 PROG_SEQ_DATA_REQ FLASH_PROG_SEQ_IDLE No new data is requested by a Sequential Program sequence.  0x0* FLASH_PROG_SEQ_REQ_NEW_DATA New data is requested by a Sequential Program sequence.  0x1 28 BUSY FLASH_IF_IDLE Indicates that the Flash interface is ready.  0x0* FLASH_IF_BUSY Indicates that the Flash interface is busy.  0x1 27 DATA_RED2_W_UNLOCK FLASH_DATA_RED2_W_LOCKED Indicates that the Flash Data array RED2 sector is protected against write accesses by the Flash interface  0x0* FLASH_DATA_RED2_W_UNLOCKED Indicates that the Flash Data array RED2 sector can be write accessed by ..."},"679":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ADDR.htm",l:-1,t:"FLASH_ADDR",i:0.000485784704856514,a:"FLASH_ADDR"},"680":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_DATA.htm",l:-1,t:"FLASH_DATA",i:0.000485784704856514,a:"FLASH_DATA"},"681":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_NVR_WRITE_UNLOCK.htm",l:-1,t:"FLASH_NVR_WRITE_UNLOCK",i:0.000485784704856514,a:"FLASH_NVR_WRITE_UNLOCK Bit Field Field Name Value Symbol Value Description Hex Value 31:0 UNLOCK_KEY FLASH_NVR_KEY 32-bit key to allow for write access to the Flash NVR sector  0x71B371F5"},"682":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_NVR_CTRL.htm",l:-1,t:"FLASH_NVR_CTRL",i:0.000485784704856514,a:"Bit Field Field Name Value Symbol Value Description Hex Value 7 NVR7_W_EN NVR7_WRITE_DISABLE The Flash NVR7 block is protected against write access.  0x0* NVR7_WRITE_ENABLE The Flash NVR7 block can be written.  0x1 6 NVR6_W_EN NVR6_WRITE_DISABLE The Flash NVR6 block is protected against write access.  0x0* NVR6_WRITE_ENABLE The Flash NVR6 block can be written.  0x1 5 NVR5_W_EN NVR5_WRITE_DISABLE The Flash NVR5 block is protected against write access.  0x0* NVR5_WRITE_ENABLE The Flash NVR5 block can be written.  0x1 4 NVR4_W_EN NVR4_WRITE_DISABLE The Flash NVR4 block is protected against write access.  0x0* NVR4_WRITE_ENABLE The Flash NVR4 block can be written.  0x1 3 NVR3_W_EN NVR3_WRITE_DISABLE The Flash NVR3 block is protected against write access.  0x0* NVR3_WRITE_ENABLE The Flash NVR3 block can be written.  0x1 2 NVR2_W_EN NVR2_WRITE_DISABLE The Flash NVR2 block is protected against write access.  0x0* NVR2_WRITE_ENABLE The Flash NVR2 block can be written.  0x1 1 NVR1_W_EN ..."},"683":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_PATCH_ADDR.htm",l:-1,t:"FLASH_PATCH_ADDR",i:0.000485784704856514,a:"FLASH_PATCH_ADDR Bit Field Field Name Value Symbol Value Description Hex Value 31 PATCH_NOT_VALID PATCH_VALID This bit must be cleared in order for the patching to be taken into consideration.  0x0 PATCH_NOT_VALID 0x1*"},"684":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_COPY_CFG.htm",l:-1,t:"FLASH_COPY_CFG",i:0.000564822928736803,a:"FLASH_COPY_CFG Bit Field Field Name Value Symbol Value Description Hex Value 18 COMP_ADDR_STEP COMP_ADDR_STEP_1 Address increment/decrement by 1 between two reads  0x0* COMP_ADDR_STEP_2 Address increment/decrement by 2 between two reads  0x1 17 COMP_ADDR_DIR COMP_ADDR_DOWN FLASH_COPIER address count-down  0x0 COMP_ADDR_UP FLASH_COPIER address count-up  0x1* 16 COMP_MODE COMP_MODE_CONSTANT FLASH_DATA[1:0] compare with Flash DOUT  0x0* COMP_MODE_CHBK Odd address compare with FLASH_DATA[1:0], even address compare with inverse FLASH_DATA[1:0]  0x1 9 COPY_DEST COPY_TO_MEM Copy Flash to memory  0x0* COPY_TO_CRC Copy Flash to CRC  0x1 8 COPY_MODE COPY_TO_32BIT Copy Flash to 32-bit memory  0x0* 1 PRIORITY FLASH_CM33_PRIORITY CM33 has priority over Flash Copier  0x0* FLASH_COPY_PRIORITY Flash Copier has priority over CM33  0x1 0 MODE COPY_MODE Flash copier mode  0x0* COMPARATOR_MODE Flash comparator mode  0x1"},"685":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_COPY_CTRL.htm",l:-1,t:"FLASH_COPY_CTRL",i:0.000564822928736803,a:"FLASH_COPY_CTRL Bit Field Field Name Value Symbol Value Description Hex Value 3 ERROR COPY_NO_ERROR No write / comparison error  0x0* COPY_ERROR Write or comparison error  0x1 2 STOP COPY_STOP Stop the current transfer  0x1 1 START COPY_START Start the current transfer  0x1 0 BUSY COPY_IDLE Flash copier is idle  0x0* COPY_BUSY Flash copier is busy  0x1"},"686":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_COPY_SRC_ADDR_PTR.htm",l:-1,t:"FLASH_COPY_SRC_ADDR_PTR",i:0.000564822928736803,a:"FLASH_COPY_SRC_ADDR_PTR"},"687":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_COPY_DST_ADDR_PTR.htm",l:-1,t:"FLASH_COPY_DST_ADDR_PTR",i:0.000564822928736803,a:"FLASH_COPY_DST_ADDR_PTR"},"688":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_COPY_WORD_CNT.htm",l:-1,t:"FLASH_COPY_WORD_CNT",i:0.000564822928736803,a:"FLASH_COPY_WORD_CNT"},"689":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ECC_CTRL.htm",l:-1,t:"FLASH_ECC_CTRL",i:0.000485784704856514,a:"FLASH_ECC_CTRL Bit Field Field Name Value Symbol Value Description Hex Value 15:8 ECC_COR_CNT_INT_THRESHOLD FLASH_ECC_COR_INT_THRESHOLD_DISABLED Interrupt is disabled  0x0 FLASH_ECC_COR_INT_THRESHOLD_1 Send a CM33 interrupt when one or more correctable errors are detected.  0x1* FLASH_ECC_COR_INT_THRESHOLD_255 Send a CM33 interrupt when 255 or more correctable errors are detected.  0xFF 3 COPIER_ECC_CTRL FLASH_COPIER_ECC_DISABLE Disables ECC when reading Flash through Flash Copier  0x0 FLASH_COPIER_ECC_ENABLE Enables ECC when reading Flash through Flash Copier  0x1* 2 CMD_ECC_CTRL FLASH_CMD_ECC_DISABLE Disables ECC when reading Flash through Flash mapped register  0x0 FLASH_CMD_ECC_ENABLE Enables ECC when reading Flash through Flash mapped register  0x1* 0 CBUS_ECC_CTRL FLASH_CBUS_ECC_DISABLE Disables ECC when reading Flash through CBus  0x0 FLASH_CBUS_ECC_ENABLE Enables ECC when reading Flash through CBus  0x1*"},"690":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ECC_STATUS.htm",l:-1,t:"FLASH_ECC_STATUS",i:0.000485784704856514,a:"FLASH_ECC_STATUS Bit Field Field Name Value Symbol Value Description Hex Value 6 ECC_COR_ERROR_CNT_CLEAR FLASH_ECC_COR_ERROR_CNT_CLEAR Reset the Flash corrected errors counter  0x1 5 ECC_UNCOR_ERROR_CNT_CLEAR FLASH_ECC_UNCOR_ERROR_CNT_CLEAR Reset the Flash uncorrected errors counter  0x1 4 ECC_ERROR_ADDR_CLEAR FLASH_ECC_ERROR_ADDR_CLEAR Reset the Flash address of the latest detected error  0x1 1 ECC_COR_ERROR_CNT_STATUS FLASH_ECC_NO_CORRECTED_ERROR Indicates FLASH_ECC_COR_ERROR_CNT is zero  0x0* FLASH_ECC_CORRECTED_ERROR Indicates FLASH_ECC_COR_ERROR_CNT is not zero  0x1 0 ECC_UNCOR_ERROR_CNT_STATUS FLASH_ECC_NO_UNCORRECTED_ERROR Indicates FLASH_ECC_UNCOR_ERROR_CNT is zero  0x0* FLASH_ECC_UNCORRECTED_ERROR Indicates FLASH_ECC_UNCOR_ERROR_CNT is not zero  0x1"},"691":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ECC_ERROR_ADDR.htm",l:-1,t:"FLASH_ECC_ERROR_ADDR",i:0.000485784704856514,a:"FLASH_ECC_ERROR_ADDR"},"692":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ECC_UNCOR_ERROR_CNT.htm",l:-1,t:"FLASH_ECC_UNCOR_ERROR_CNT",i:0.000485784704856514,a:"FLASH_ECC_UNCOR_ERROR_CNT"},"693":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_ECC_COR_ERROR_CNT.htm",l:-1,t:"FLASH_ECC_COR_ERROR_CNT",i:0.000485784704856514,a:"FLASH_ECC_COR_ERROR_CNT"},"694":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_NVM_STATUS.htm",l:-1,t:"FLASH_NVM_STATUS",i:0.000485784704856514,a:"FLASH_NVM_STATUS Bit Field Field Name Value Symbol Value Description Hex Value 16 CLEAR_NVM_STATUS CLEAR_NVM_STATUS Clear all the NVM status bits  0x1 8 NVM_BIT_FAILURE NVM_OK No bit failure detection in the CC-NVM layout  0x0* NVM_BIT_FAILED At least a bit has failed in the CC-NVM layout  0x1"},"695":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_MAIN_MASK.htm",l:-1,t:"FLASH_MAIN_MASK",i:0.000485784704856514,a:"Bit Field Field Name Value Symbol Value Description Hex Value 11 DATA_A_35K_TO_40K_W_MASK DATA_A_35K_TO_40K_W_NOT_ACCESSIBLE The part K to K of the Flash MAIN Data array is not accessible.  0x0 DATA_A_35K_TO_40K_W_ACCESSIBLE The part K to K of the Flash MAIN Data array is accessible.  0x1* 10 DATA_A_30K_TO_35K_W_MASK DATA_A_30K_TO_35K_W_NOT_ACCESSIBLE The part K to K of the Flash MAIN Data array is not accessible.  0x0 DATA_A_30K_TO_35K_W_ACCESSIBLE The part K to K of the Flash MAIN Data array is accessible.  0x1* 9 DATA_A_25K_TO_30K_W_MASK DATA_A_25K_TO_30K_W_NOT_ACCESSIBLE The part K to K of the Flash MAIN Data array is not accessible.  0x0 DATA_A_25K_TO_30K_W_ACCESSIBLE The part K to K of the Flash MAIN Data array is accessible.  0x1* 8 DATA_A_20K_TO_25K_W_MASK DATA_A_20K_TO_25K_W_NOT_ACCESSIBLE The part K to K of the Flash MAIN Data array is not accessible.  0x0 DATA_A_20K_TO_25K_W_ACCESSIBLE The part K to K of the Flash MAIN Data array is accessible.  0x1* 7 ..."},"696":{y:0,u:"../Content/detail/rsl15_Flash_Interface_FLASH_IF_ID_NUM.htm",l:-1,t:"FLASH_IF_ID_NUM",i:0.000485784704856514,a:"FLASH_IF_ID_NUM Bit Field Field Name Value Symbol Value Description Hex Value 20 FLASH_IF_NVR_FOR_CC312 NVR_SECTORS_AVAILABLE NVR sectors 0 to 3 are available to the user  0x0* NVR_SECTORS_USED_BY_CRYPTOCELL NVR sectors 0 to 3 are used by the CryptoCell and are not available to the user  0x1 15:8 FLASH_IF_MAJOR_REVISION FLASH_IF_MAJOR_REVISION Flash interface revision 1.0  0x1* 7:0 FLASH_IF_MINOR_REVISION FLASH_IF_MINOR_REVISION Flash interface revision 1.0  0x0*"},"697":{y:0,u:"../Content/hardware_reference_rsl15/hwref_Memory_MemReg.htm",l:-1,t:"Memory  Registers",i:0.000710950880372257,a:"Memory  Registers"},"698":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_CM33_LOOP_CACHE_CFG.htm",l:-1,t:"SYSCTRL_CM33_LOOP_CACHE_CFG",i:0.000523257720031035,a:"SYSCTRL_CM33_LOOP_CACHE_CFG Bit Field Field Name Value Symbol Value Description Hex Value 0 CM33_LOOP_CACHE_ENABLE CM33_LOOP_CACHE_DISABLE CM33 loop cache disabled  0x0* CM33_LOOP_CACHE_ENABLE CM33 loop cache enabled  0x1"},"699":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_ACCESS_ERROR.htm",l:-1,t:"SYSCTRL_ACCESS_ERROR",i:0.000523257720031035,a:"SYSCTRL_ACCESS_ERROR Bit Field Field Name Value Symbol Value Description Hex Value 16 ACCESS_ERROR_CLEAR SYSCTRL_ACCESS_ERROR_CLEAR Clear the access error flags  0x1 12 CC312_MEM_ERROR CC312_MEM_NO_ERROR_DETECTED No CC312 memory error detected  0x0* CC312_MEM_ERROR_DETECTED CC312 has accessed an isolated memory  0x1 10 DMA_PERIPH_ERROR DMA_PERIPH_NO_ERROR_DETECTED No DMA peripheral access error detected  0x0* DMA_PERIPH_ERROR_DETECTED DMA received a peripheral access error  0x1 9 DMA_MEM_ERROR DMA_MEM_NO_ERROR_DETECTED No DMA memory error detected  0x0* DMA_MEM_ERROR_DETECTED DMA has accessed an isolated memory  0x1 8 BB_MEM_ERROR BB_MEM_NO_ERROR_DETECTED No baseband memory error detected  0x0* BB_MEM_ERROR_DETECTED Baseband has accessed an isolated memory  0x1 0 FLASH_COPIER_MEM_ERROR FLASH0_COPIER_MEM_NO_ERROR_DETECTED No FLASH copier memory error detected  0x0* FLASH0_COPIER_MEM_ERROR_DETECTED FLASH0 copier has accessed an isolated memory  0x1"},"700":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_MEM_POWER_STARTUP.htm",l:-1,t:"SYSCTRL_MEM_POWER_STARTUP",i:0.000523257720031035,a:"Bit Field Field Name Value Symbol Value Description Hex Value 17:16 BB_DRAM_STARTUP BB_DRAM0_POWER_OFF Baseband DRAM0 startup disabled  0x0 BB_DRAM1_POWER_OFF Baseband DRAM1 startup disabled  0x0 BB_DRAM0_POWER_STARTUP Baseband DRAM0 startup enabled  0x1 BB_DRAM1_POWER_STARTUP Baseband DRAM1 startup enabled  0x2 15:8 DRAM_STARTUP DRAM0_POWER_OFF DRAM0 startup disabled  0x0 DRAM1_POWER_OFF DRAM1 startup disabled  0x0 DRAM2_POWER_OFF DRAM2 startup disabled  0x0 DRAM3_POWER_OFF DRAM3 startup disabled  0x0 DRAM4_POWER_OFF DRAM4 startup disabled  0x0 DRAM5_POWER_OFF DRAM5 startup disabled  0x0 DRAM6_POWER_OFF DRAM6 startup disabled  0x0 DRAM7_POWER_OFF DRAM7 startup disabled  0x0 DRAM0_POWER_STARTUP DRAM0 startup enabled  0x1 DRAM1_POWER_STARTUP DRAM1 startup enabled  0x2 DRAM2_POWER_STARTUP DRAM2 startup enabled  0x4 DRAM3_POWER_STARTUP DRAM3 startup enabled  0x8 DRAM4_POWER_STARTUP DRAM4 startup enabled  0x10 DRAM5_POWER_STARTUP DRAM5 startup enabled  0x20 DRAM6_POWER_STARTUP DRAM6 ..."},"701":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_MEM_POWER_ENABLE.htm",l:-1,t:"SYSCTRL_MEM_POWER_ENABLE",i:0.000523257720031035,a:"Bit Field Field Name Value Symbol Value Description Hex Value 17:16 BB_DRAM_ENABLE BB_DRAM0_POWER_DISABLE Baseband DRAM0 disabled  0x0* BB_DRAM1_POWER_DISABLE Baseband DRAM1 disabled  0x0* BB_DRAM0_POWER_ENABLE Baseband DRAM0 enabled  0x1 BB_DRAM1_POWER_ENABLE Baseband DRAM1 enabled  0x2 15:8 DRAM_ENABLE DRAM0_POWER_DISABLE DRAM0 disabled  0x0 DRAM1_POWER_DISABLE DRAM1 disabled  0x0 DRAM2_POWER_DISABLE DRAM2 disabled  0x0 DRAM3_POWER_DISABLE DRAM3 disabled  0x0 DRAM4_POWER_DISABLE DRAM4 disabled  0x0 DRAM5_POWER_DISABLE DRAM5 disabled  0x0 DRAM6_POWER_DISABLE DRAM6 disabled  0x0 DRAM7_POWER_DISABLE DRAM7 disabled  0x0 DRAM0_POWER_ENABLE DRAM0 enabled  0x1* DRAM1_POWER_ENABLE DRAM1 enabled  0x2 DRAM2_POWER_ENABLE DRAM2 enabled  0x4 DRAM3_POWER_ENABLE DRAM3 enabled  0x8 DRAM4_POWER_ENABLE DRAM4 enabled  0x10 DRAM5_POWER_ENABLE DRAM5 enabled  0x20 DRAM6_POWER_ENABLE DRAM6 enabled  0x40 DRAM7_POWER_ENABLE DRAM7 enabled  0x80 1 FLASH_ENABLE FLASH0_POWER_DISABLE FLASH0 disabled  0x0* ..."},"702":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_MEM_ACCESS_CFG.htm",l:-1,t:"SYSCTRL_MEM_ACCESS_CFG",i:0.000523257720031035,a:"Bit Field Field Name Value Symbol Value Description Hex Value 17:16 BB_DRAM_ACCESS BB_DRAM0_ACCESS_DISABLE Baseband DRAM0 access disabled  0x0* BB_DRAM1_ACCESS_DISABLE Baseband DRAM1 access disabled  0x0* BB_DRAM0_ACCESS_ENABLE Baseband DRAM0 access enabled  0x1 BB_DRAM1_ACCESS_ENABLE Baseband DRAM1 access enabled  0x2 15:8 DRAM_ACCESS DRAM0_ACCESS_DISABLE DRAM0 access disabled  0x0 DRAM1_ACCESS_DISABLE DRAM1 access disabled  0x0 DRAM2_ACCESS_DISABLE DRAM2 access disabled  0x0 DRAM3_ACCESS_DISABLE DRAM3 access disabled  0x0 DRAM4_ACCESS_DISABLE DRAM4 access disabled  0x0 DRAM5_ACCESS_DISABLE DRAM5 access disabled  0x0 DRAM6_ACCESS_DISABLE DRAM6 access disabled  0x0 DRAM7_ACCESS_DISABLE DRAM7 access disabled  0x0 DRAM0_ACCESS_ENABLE DRAM0 access enabled  0x1* DRAM1_ACCESS_ENABLE DRAM1 access enabled  0x2 DRAM2_ACCESS_ENABLE DRAM2 access enabled  0x4 DRAM3_ACCESS_ENABLE DRAM3 access enabled  0x8 DRAM4_ACCESS_ENABLE DRAM4 access enabled  0x10 DRAM5_ACCESS_ENABLE DRAM5 access enabled  0x20 ..."},"703":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_MEM_RETENTION_CFG.htm",l:-1,t:"SYSCTRL_MEM_RETENTION_CFG",i:0.000523257720031035,a:"Bit Field Field Name Value Symbol Value Description Hex Value 17:16 BB_DRAM_RETENTION BB_DRAM0_NORMAL_MODE Baseband DRAM0 normal mode  0x0 BB_DRAM1_NORMAL_MODE Baseband DRAM1 normal mode  0x0 BB_DRAM0_RETENTION_MODE Baseband DRAM0 retention mode  0x1 BB_DRAM1_RETENTION_MODE Baseband DRAM1 retention mode  0x2 15:8 DRAM_RETENTION DRAM0_NORMAL_MODE DRAM0 normal mode  0x0 DRAM1_NORMAL_MODE DRAM1 normal mode  0x0 DRAM2_NORMAL_MODE DRAM2 normal mode  0x0 DRAM3_NORMAL_MODE DRAM3 normal mode  0x0 DRAM4_NORMAL_MODE DRAM4 normal mode  0x0 DRAM5_NORMAL_MODE DRAM5 normal mode  0x0 DRAM6_NORMAL_MODE DRAM6 normal mode  0x0 DRAM7_NORMAL_MODE DRAM7 normal mode  0x0 DRAM0_RETENTION_MODE DRAM0 retention mode  0x1 DRAM1_RETENTION_MODE DRAM1 retention mode  0x2 DRAM2_RETENTION_MODE DRAM2 retention mode  0x4 DRAM3_RETENTION_MODE DRAM3 retention mode  0x8 DRAM4_RETENTION_MODE DRAM4 retention mode  0x10 DRAM5_RETENTION_MODE DRAM5 retention mode  0x20 DRAM6_RETENTION_MODE DRAM6 retention mode  0x40 ..."},"704":{y:0,u:"../Content/detail/rsl15_System_Control_SYSCTRL_MEM_TIMING_CFG.htm",l:-1,t:"SYSCTRL_MEM_TIMING_CFG",i:0.000523257720031035,a:"SYSCTRL_MEM_TIMING_CFG Bit Field Field Name Value Symbol Value Description Hex Value 22:20 RAM_PKA_EMA RAM_PKA_EMA_MIN RAM minimum extra margin  0x0 RAM_PKA_EMA_DEFAULT RAM default extra margin  0x2* RAM_PKA_EMA_MAX RAM maximum extra margin  0x7 17:16 RAM_PKA_EMAW RAM_PKA_EMAW_DEFAULT RAM default/minimum extra write margin  0x0* RAM_PKA_EMAW_MAX RAM maximum extra write margin  0x3 6:4 PROM_EMA PROM_EMA_MIN PROM minimum extra margin  0x0 PROM_EMA_DEFAULT PROM default extra margin  0x2* PROM_EMA_MAX PROM maximum extra margin  0x7 0 PROM_KEN PROM_KEN_ENABLED PROM bit lines keeper enabled  0x0 PROM_KEN_DISABLED PROM bit lines keeper disabled  0x1*"},"705":{y:0,u:"../Content/hardware_reference_rsl15/hwref_GenPurposeIO_LP.htm",l:-1,t:"General Purpose Input/Output",i:0.0016399826665329,a:"General Purpose Input/Output This topic covers the configuration, use, and control of the RSL15‘s 16 GPIO pads. For more information about this topic, see:"},"706":{y:0,u:"../Content/hardware_reference_rsl15/hwref_GenPurposeIO_Overview.htm",l:-1,t:"Overview",i:0.000813376085734114,a:"The RSL15 system contains 16 general purpose input/output (GPIO) pads that can be configured: To support the sensor and communications interfaces, output clocks, and other I/Os As general-purpose I/Os controllable from the Arm Cortex-M33 core The RSL15 system includes dedicated I/O pads for the following functionalities: The SWDCLK and SWDIO (also used as JTCK  and JTMS) pads for the standard SWJ-DP debug port included with the Arm Cortex-M33 core — for more information, see  Debug Port . A reset pad (NRESET) — for more information, see  Resets . An antenna pad (RF) — for more information, see  RF Front-End . All other input and output functionality is routed through 16 configurable GPIOs.  For more information about the functional configuration of GPIO pads, see  Functional Configuration . The GPIO pads support a variety of physical configuration parameters that can be used to properly interface with external components. These configuration parameters include: Pull-up and pull-down ..."},"707":{y:0,u:"../Content/hardware_reference_rsl15/hwref_GenPurposeIO_FunctionalCfg.htm",l:-1,t:"Functional Configuration",i:0.00210913447038886,a:"The GPIO pads can be configured using the GPIO_CFG_IO_MODE bit field from the GPIO_CFG_* registers: For a variety of digital output modes For a general-purpose digital input mode, with the input function configured by the GPIO_SRC_* registers  The  \"GPIO Use Case Multiplexing\" table  contains a list of the multiplexed functional modes for which GPIOs can be configured.  In addition to standard digital functional configuration, certain GPIOs can be configured for  operation in both run and low power modes, such as Sleep Mode. Specifically: Wakeup functionality is only available on GPIO[0:3]; see  Power Modes  for more information. The RTC clock can be output on GPIO0; see  Clock Generation  for more information. The PWM (always-on) can be output on GPIO4; see  PWM  for more information. The simple DAC can be output on GPIO7; see  Simple Low-Power DAC  for more information. These special modes require the GPIO to be placed in a high impedance mode, with its digital input and output ..."},});