define({"70":{y:0,u:"../Content/firmware_reference/fwref_HWDefs_InterruptVectorDef.htm",l:-1,t:"Interrupt Vector Definition",i:0.000447713649571742,a:"Interrupt vectors provide you with access to interrupts that facilitate orderly processing operations, for optimal application processing speed and minimal delays. Interrupt vector definitions are provided for the Arm Cortex-M33 processor  in the  rsl15_vectors.h header file. Interrupt handling functionality in the Arm Cortex-M33 processor is provided by a nested vector interrupt controller (NVIC) implemented with the processor. The NVIC handles predefined interrupts internal to the core including a non-maskable interrupt (NMI), and interrupts external to the processor, that are linked to interfaces and peripherals. The NVIC is supported by standard firmware as part of the CMSIS library (as described in  CMSIS Library ), and  by the Hardware Abstraction Layer library (described in  Hardware Abstraction Layer ), which offers  additional supporting functions. These definitions have the form \u003cinterrupt_name\u003e_IRQn.  For more information and a complete list of interrupt vectors, along with ..."},"71":{y:0,u:"../Content/firmware_reference/fwref_HWAbstractionLayer_LP.htm",l:-1,t:"Hardware Abstraction Layer",i:0.000947172903632285,a:"Hardware Abstraction Layer The Hardware Abstraction Layer (HAL) library provides a set of multiple register access functions for the majority of the system components included in the RSL15 SoC. These functions, and the included function headers, can easily be used to configure the hardware blocks through safe register accesses with no need to refer to register tables and corresponding settings in the RSL15. The HAL library is distributed in source-code form in the RSL15 SDK. All the library functions are blocking and interruptible. The library does not use any interrupts or DMA channels. For more information about this topic, see:"},"72":{y:0,u:"../Content/firmware_reference/fwref_HWAbstractionLayer_Usage.htm",l:-1,t:"Usage",i:0.000447713649571742,a:"Usage To use the HAL library functions, the HAL library must be included via the project’s *.rteconfig file, under Libraries. Additionally, the  rsl15.h header file must be included in the application source. The HAL functions follow Sys_\u003chardware block\u003e_\u003cfunction\u003e name syntax, with:  \u003chardware block\u003e indicating the system component being configured or acted upon In some cases, the hardware block is prefixed by a standard operation such as Set_ or Get_ \u003cfunction\u003e describing the functionality implemented by the HAL firmware  Simple wrapper macros, with the same names but capitalized, are also provided for many functions. These macros do not require a user application to provide a pointer to the block being configured or operated upon, as the macros default to the first instance available. For example, SYS_I2C_CONFIG is a macro that calls the Sys_I2C_Config function with I2C0 for the pointer parameter. For the complete HAL library API, refer to  Hardware Abstraction Layer Reference ."},"73":{y:0,u:"../Content/firmware_reference/fwref_CMSISLibrary_LP.htm",l:-1,t:"CMSIS Library",i:0.000638001766283776,a:"CMSIS Library The Arm Cortex-M33 processor is supported by a  standards-compliant CMSIS library and extensions to the CMSIS requirements. For more information about this topic, see:"},"74":{y:0,u:"../Content/firmware_reference/fwref_CMSISLibrary.htm",l:-1,t:"Introduction",i:0.00109111077429777,a:"The Arm Cortex-M33 processor is supported by a  standards-compliant CMSIS library and extensions to the CMSIS requirements. The CMSIS library performs the following functions: Provides access to the generic functions provided by the standard Arm CMSIS implementation The functions are included in the CMSIS header files, and reference documentation is provided by the standard Arm CMSIS documentation ( http://arm-software.github.io/CMSIS_5/Core/html/modules.html ). Implements the CMSIS-required device-specific functions with an appropriate implementation for RSL15 Adds extensions to the generic and required CMSIS functions to provide additional common support functions, including: Weak definitions for all interrupt handlers for the Arm Cortex-M33 processor and associated NVIC A C start-up routine for ensuring that applications reach main in a safe state Dynamic memory allocation (through an implementation of sbrk) Hardware-safe functions for updating the system clock source and operating ..."},"75":{y:0,u:"../Content/firmware_reference/fwref_CMSIS_LP.htm",l:-1,t:"CMSIS Drivers",i:0.000447713649571742,a:"CMSIS Drivers The CMSIS drivers are generic device-independent APIs for peripherals, including I2C, SPI, and UART. These drivers are created to allow easy setup and use of peripherals and interfaces by handling most of the manual configuration work in the back-end. The drivers can be used in the sample applications by including the appropriate interface header files and the CMSIS drivers library. For more information about this topic, see:"},"76":{y:0,u:"../Content/firmware_reference/fwref_CMSIS_Intro.htm",l:-1,t:"Introduction",i:0.00298346005075112,a:"Introduction This topic presents the description of all the available CMSIS drivers and the instructions on how to use the configuration file (RTE_Device.h). The specifications and headers for all of the functions used in these CMSIS drivers have been provided by Arm, and the corresponding documentation can be found on the Arm Keil website, on this page:  http://www.keil.com/pack/doc/CMSIS/Driver/html/index.html . This topic assumes that the user is familiar with importing projects into the IDE, and also with the location of the sample applications. For more information about these topics, see the RSL15 Getting Started Guide. A list of interfaces with CMSIS driver support is shown in the  \"Interfaces for Which a CMSIS Driver is  Available\" table . The drivers used for CMSIS pack sample applications are shown in the  \"Types of Drivers\" table :"},"77":{y:0,u:"../Content/firmware_reference/fwref_CMSIS_IncludingCMSIS_Drivers.htm",l:-1,t:"Using the CMSIS Drivers",i:0.00298346005075112,a:"CMSIS  drivers provide generic peripheral interfaces for middleware and application code. To use the CMSIS driver library, the drivers must be included in the application. Instructions for using the CMSIS drivers are shown in the following sections. Adding a CMSIS Driver To add a CMSIS driver to an application, perform the following steps: Open the \u003csample_name\u003e.rtconfig file from the project folder and select the CMSIS driver(s) that is/are required for the application. CMSIS drivers, including UART, SPI and I2C, are found under CMSIS Drivers in the application’s .rteconfig file. After enabling required drivers, save the  \u003csample_name\u003e.rtconfig file. See the  \"Adding the UART CMSIS Driver to the uart_cmsis Sample Application\" figure  as an example of how to add the USART CMSIS driver to the uart_cmsis sample application. As seen in the figure, the USART driver for RSL15 is checked, and is therefore included in the sample application.  Adding the UART CMSIS Driver to the uart_cmsis ..."},"78":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_LP.htm",l:-1,t:"Program ROM",i:0.000638001766283776,a:"Program ROM The RSL15 Program ROM is responsible for ensuring that an RSL15 device\ncorrectly performs a controlled boot sequence allowing application code to\nexecute. The Program ROM does this while taking into account the possible life cycle states of\nthe device, the active power modes, and any required security functionality. In addition to bringing the system up, the program ROM also ensures that the\ndefault state of a device is consistent after a cold boot sequence. Finally, the ROM provides access to commonly-used functionality that\ncan be called from application code, allowing these functions to be eliminated\nfrom the application footprint. For more information about this topic, see:"},"79":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_Overview.htm",l:-1,t:"Overview",i:0.00298346005075112,a:"Overview Versions There are three version numbers reported by the  RSL15 ROM. Each version number\nis defined as a 32-bit value containing major, minor and revision numbers in\nthe form major.minor.revision. These items are stored at predefined locations\nin the ROM program memory, as shown in the  \"ROM Versions\" table ."},"80":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_InitializationSupport.htm",l:-1,t:"ROM Initialization Sequence",i:0.000778670424020972,a:"The ROM is split into two main parts: The low level initialization and setup, which is written in assembler: this part\nis responsible for ensuring that the power supplies are set up, and that memory instances\nare enabled for default power-up conditions. The higher level functionality implemented in C dealing with\nthe various peripherals, life cycle states and security features: these are\ndefined in more detail in  Security Subsystem . The ROM initialization sequence is shown graphically in the  \"ROM Initialization Sequence Flowchart\" figure . The flowchart  describes the various paths through the boot sequence,\ntaking into account the possible life cycle states and power modes. ROM Initialization Sequence Flowchart The  \"Boot Options\" table  shows the available boot options. ROM Basic Initialization The basic system initialization function is called once the power\nsupplies and memories have been set to known default states. At this stage\nthe RAM is enabled and the C stack is available ..."},"81":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_AppValidationBoot.htm",l:-1,t:"Application Validation and Boot",i:0.00298346005075112,a:"The RSL15 program ROM contains a set of functions that are used to validate and boot applications, following the completion of the security processes. The ROM considers an application valid if it starts with its vector table, and no errors that would prevent boot are detected. Possible errors, and the error codes reported for these errors, are described in the  \"Application Validation\" table . If the ROM determines that an application should be booted, the ROM: Sets the VTOR bit-field in the Arm Cortex-M33 processor’s SCB register to point to the application’s vector table Loads the initial stack pointer value from the application’s vector table to the Arm Cortex-M33 processor’s SP register Pushes the application’s status code to the  SYSCTRL_SYSCLK_CNT register (valid error codes for a booted application are None and Bad CRC, as described in the  \"Application Validation\" table ) Branches to the beginning of the reset handler, as indicated by the reset vector in the application’s ..."},"82":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_VectorTable.htm",l:-1,t:"Vector Tables",i:0.00425133325134081,a:"Vector Tables The ROM provides some access to built-in common functionality via the use of a ROM Jump Table.\nThe features provided in this jump table are defined in the  \"Jump Table Functions\" table , together with a brief\ndescription of the use of each. Access to these functions is provided through rom_vect.h (typically included through the top-level  rsl15.h include file) and flash_rom.h (used in place of flash.h)."},"83":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_SecuritySubsystem.htm",l:-1,t:"Security Subsystem",i:0.000778670424020972,a:"RSL15 includes security IP provided by Arm, specifically the Arm CryptoCell-312\n(CC312) security processor. In addition, the Arm Cortex-M33\nprocessor itself includes support for TrustZone. The ROM ensures that the hardware Root-of-Trust (RoT) is verified when running as a\nsecure device. This ensures that no untrusted code can be executed by the ROM. RSL15 also supports deployment as a non-secure device, allowing much lower\npower utilization. This mode is provided primarily for energy harvesting\napplications. However, this is not limited by design; any application can be\nexecuted in the lower security model if required. Secure Boot Process There are a limited number of steps involved when evaluating the secure\nRoot of Trust (RoT) in the secure state: Verify the peripheral ID. Get the current life cycle state. Secure debug authentication:  If debug certificates are available, they must be validated. If valid, debug facilities need to be enabled. Image verification phase: Verify the ..."},"84":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_LifeCycle.htm",l:-1,t:"ROM Life Cycle States (LCS) \u0026 Operational Modes",i:0.000447713649571742,a:"The standard Arm CryptoCell-312 secure life cycle model allows for four life cycle states: CM - Chip Manufacture DM - Device Manufacture SE - Secure The transitions between these states are strictly defined by the life cycle\nmodel, and we have maintained this in our system. In addition to the standard Arm lifecycle states, we have added an additional production state before\nCM which reflects the possibility of a device coming from manufacture with\nan unconfigured OTP. In this case, the ROM does not allow application\ncode to be run, but it does allow the device to be configured to enter CM state. In parallel to the secure life cycle model, we also provide for a non-secure\nmodel in which the device is defined to be in Energy-Harvesting (EH) state. In this\ncase, the Root of Trust security features are turned off and security is provided\nusing a security mechanism dependent on valid applications unlocking the device. A device in Production state can be configured to be in EH state. If this ..."},"85":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_DEU.htm",l:-1,t:"Data Exchange Unit (DEU) Support",i:0.000447713649571742,a:"Data Exchange Unit (DEU) Support In order to enable the debug ports and any other features controlled by the\nDebug Control Unit, certificates must be provided to the device. These can\nreside in RAM for one time only use, or can reside in flash to allow the\nport enablement to survive a cold reboot. The provision of these certificates is handled through the DEU. All interfacing\nwith the DEU is performed via the ROM code. Application code has no access to this\ndevice. The ROM supports the following features when communicating with the DEU: LOAD - Allows a certificate to be loaded to a device and stored in RAM ERASE - Erases any certificates which are currently stored in flash WRITE - Writes the current set of certificates from RAM to flash SOCID - Requests the SOC ID from the device CONNECT - Connects to a device via the DEU port COMPLETE - Completes the connection to the device   \nimg {\n\twidth: 100%;\n\theight: auto;\n}\n"},"86":{y:0,u:"../Content/firmware_reference/fwref_ProgramROM_ReservedFlash.htm",l:-1,t:"Reserved Flash Sectors",i:0.00298346005075112,a:"Reserved Flash Sectors On RSL15, the application configuration and debug certificates are held in data flash in consecutive sectors. (Data flash in RSL15 has a sector size of 256 bytes.) One sector for the application configuration One sector for the EH_STATE debug certificate Ten sectors for the ROT_STATE debug certificates Therefore, a total of 3 KB are reserved for use by the different security mechanisms. The layout of this is shown in the  \"Reserved Space for Security Mechanisms\" figure . Reserved Space for Security Mechanisms If you are not using the secure Root of Trust, then it is generally considered safe to repurpose the 10 sectors allocated to the debug certificates. The other two sectors need to be left reserved."},"87":{y:0,u:"../Content/firmware_reference/fwref_FlashLib_LP.htm",l:-1,t:"Flash Library",i:0.000447713649571742,a:"Flash Library The flash library provides support for erasing and programming parts of the built in flash memory. This library provides an API that abstracts the details needed properly handle the flash. For more information about this topic, see:"},"88":{y:0,u:"../Content/firmware_reference/fwref_FlashLib_Forms.htm",l:-1,t:"Library Forms",i:0.000447713649571742,a:"Library Forms The flash library is available in two forms: As a static library, accessed by including the flash.h header file and linking against the libflashlib.a library object As a  Program ROM component, accessed as memory mapped elements using the flash_rom.h header file For the complete flash library API, refer to Chapter 1 \"Flash Library Reference\" on page 1. Performing flash operations requires certain system conditions to be satisfied to ensure that the operations are performed safely (see the RSL15 Hardware Reference for more details). When using the flash library as a ROM component, through the flash_rom.h header file, checks of these conditions will be performed by the API functions (and the operation aborted if one of the conditions is not satisfied). When using the flash library as a static library, through the flash.h header file, the checks of these conditions will be circumvented and the user must ensure their application meets the conditions for safe flash operations."},"89":{y:0,u:"../Content/firmware_reference/fwref_FlashLib_Usage.htm",l:-1,t:"Flash Library Usage",i:0.000447713649571742,a:"The flash library can be used to program and erase the built-in flash, with the following considerations: A minimum SYSCLK frequency of 1 MHz, sourced from a clock source with an error below ±10%, is required for safe operation of the flash library. The SYSCLK must be sourced from the RFCLK (48 MHz XTAL) to meet its accuracy requirement. The MNVR section of flash, outside of the user-defined redundancy sector pointers, cannot be written using the flash library. The endurance of flash is limited by the total time flash cells are subjected to program and erase currents. As a result, a number of flash operations provide options around the endurance of the flash cells: Flash writes can use a one stage normal write or a two stage endurance write. For use cases where an area of flash is written many times, a two stage write is recommended. Use of mass erase can speed up flash operations, as it is the quickest way to erase the whole flash array - but use of mass erase subjects the whole array ..."},"90":{y:0,u:"../Content/firmware_reference/fwref_Security_LP.htm",l:-1,t:"Security and Life Cycle Provisioning Elements",i:0.000447713649571742,a:"Security and Life Cycle Provisioning Elements Information about the security and lifetime provisioning elements for RSL15 is primarily found in the RSL15 Security User\u0027s Guide. For more information about this topic, see:"},"91":{y:0,u:"../Content/firmware_reference/fwref_Security_Overview.htm",l:-1,t:"Overview",i:0.000447713649571742,a:"Overview The Security and Life Cycle Provisioning process can be managed using RSLSec, which is a software utility available for RSL15. Its command line interface enables users to perform the transitions and access other security features through parameters, as described in the RSL15 Security User\u0027s Guide. This utility works to leverage the underlying security system for RSL15, including the ROM and security IP."},"92":{y:0,u:"../Content/firmware_reference/fwref_Security_ThirdPartyDocs.htm",l:-1,t:"Third Party Documentation",i:0.000447713649571742,a:"Third Party Documentation The Arm TrustZone CryptoCell-312 Software Developers Manual (SW Revision r0p0) is provided with the RSL15 SDK, in PDF form in the Arm_documentation folder. Additional third-party information can be found on the  https://developer.arm.com/ip-products/security-ip/trustzone/trustzone-for-cortex-m  webpage."},"93":{y:0,u:"../Content/firmware_reference/fwref_Crypto_LP.htm",l:-1,t:"Arm CryptoCell-312 Security IP",i:0.000447713649571742,a:"Arm CryptoCell-312 Security IP The RSL15 system includes the Arm CryptoCell-312 IP, which is used to maintain security of the device, allow secure operation of the application firmware, and permit related user applications to access security features. A significant part of the Arm CryptoCell-312’s operation is based on the use of the Mbed TLS libraries. For more information about this topic, see:"},"94":{y:0,u:"../Content/firmware_reference/fwref_Crypto_Mbedtls.htm",l:-1,t:"Arm CryptoCell-312 Mbed TLS",i:0.000447713649571742,a:"Arm CryptoCell-312 Mbed TLS RSL15 provides a standardized interface to the cryptographic features on the\ndevice using a customized version of Mbed TLS, which has been tuned to make efficient\nuse of the cryptographic acceleration hardware provided by the Arm CryptoCell-312. At present, the Mbed TLS variant supported by RSL15 is version 2.16.2. Some features of\nthis have been replaced by alternative versions to make the best use of the underlying\nhardware. The interface has been maintained so that standard Mbed TLS applications can work as expected. For further information on developing cryptographic applications with RSL15, refer to the Arm CryptoCell-312 Runtime Software Developers Manual, Issue 01, revision r1p3."},"95":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_LP.htm",l:-1,t:"Event Kernel",i:0.000447713649571742,a:"Event Kernel Some of the material in this topic has been adapted with permission from CEVA documentation. This chapter is intended to complement the CEVA API documentation included with your RSL15 install. The RSL15 event kernel is a small and efficient event and message handling system that can be used as a Real Time Operating System (RTOS) or as a process executed under an RTOS, offering the following features: Exchange of messages\n Message saving \nTimer functionality  \nThe kernel also provides an event functionality used to defer actions \nThe purpose of the event kernel is to provide messages (such as the ones in  Messages ) and timed tasks to keep RF traffic on schedule and aligned with the specification requirements. For more information about this topic, see:"},"96":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_Overview.htm",l:-1,t:"Overview",i:0.00893591538204311,a:"Overview Include Files The  \"Kernel File List\" table  shows a list of the kernel include files, with descriptions. Kernel Environment The kernel environment structure contains the queues used for event, timer and message management, including: A queue of sent messages that have not yet been delivered to the receiver A queue of messages delivered to the receiver, but not yet consumed A queue for timer events"},"97":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_Messages.htm",l:-1,t:"Messages",i:0.00210249752181789,a:"Overview Message queues provide a mechanism to transmit one or more messages to a task. (Queue names and purposes are defined in  Kernel Environment .) Transmission of messages is performed in three steps:\n Sender task allocates a message structure\n Message parameters are filled \nMessage structure is pushed in the kernel A message is identified by a unique ID composed of the task type and an increasing number. A message has a list of parameters that is defined in a structure (see  Message Format ). Message Format The structure of the message contains: id: Message identifier\n dest_id: Destination kernel identifier\n src_id: Source kernel identifier\n param_len: Parameter embedded structure length param: Parameter embedded structure. Must be word-aligned. The source and destination tasks describe which task the message is coming from/to. As a task can implement\nmultiple instances, these source and destination task identifiers are constructed with both the task index and the\ntask type, as ..."},"98":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_Scheduler.htm",l:-1,t:"Scheduler",i:0.0011096271984702,a:"Scheduler Overview The scheduler is called in the main loop of the user application using the BLE_Kernel_Process() function.\n In the user application’s main loop, the kernel checks if the event field is non-null, and executes the event handlers for which the corresponding event bit is set. Requirements Scheduling Algorithm The  \"Scheduling Algorithm\" figure  shows how the scheduler handles messages. The message handler pops messages from the message queue, passes them to the pre-defined message handler, and then handles either releasing or saving those messages based on the responses from those handlers. Scheduling Algorithm Save Service The Save service can save a message (i.e., store it in memory without it being consumed). If the task state changes after a message is received, the scheduler tries to handle the saved message before scheduling any other signals."},"99":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_Tasks.htm",l:-1,t:"Tasks",i:0.00298346005075112,a:"Tasks A kernel task is defined by: Its task type (i.e., a constant value defined by the kernel, unique for each task) Its task descriptor, which is a structure as shown in the  \"Task Descriptor Construction\" figure  containing all the information about the task: The messages handlers table The states table The number of instances of the task The number of messages it can handle The kernel keeps a pointer to each task descriptor, which is used to handle the scheduling of the messages transmitted from one task to another. Task Descriptor Construction"},"100":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_KernelTimer.htm",l:-1,t:"Kernel Timer",i:0.00298346005075112,a:"Overview The RW Kernel provides:  A time reference (absolute time counter) Timer services to start and stop the timer \nTimers are implemented by means of a reserved queue of delayed messages.\nTimer messages do not have parameters. Time Definition Time is defined as duration; the minimum step is a multiple of 1 ms. Timer Object The structure of the timer message contains: *next: Pointer on the next timer id: Message identifier task: Destination task identifier time: Duration Timer Setting The  \"Timer Setting Flow\" figure  shows the flow for setting up timer messages. Timer Setting Flow Time Primitives Timer Set Set a timer. Prototype: void ke_timer_set(ke_msg_id_t const timer_id, ke_task_id_t const task, uint32_t const delay); Parameters: Return: None Description: The function first cancels the timer if it exists; then it creates a new one. When the timer expires, a message is sent to the task provided as\n argument, with the timer id as message id. Timer Clear Remove a registered timer. ..."},"101":{y:0,u:"../Content/firmware_reference/fwref_EventKernel_UsefulMacros.htm",l:-1,t:"Useful Macros",i:0.000447713649571742,a:"Useful Macros Builds the task identifier from the type and the index of that task: #define KE_BUILD_ID(type, index) ( (ke_task_id_t)(((index) \u003c\u003c 8)|(type)) ) \nRetrieves task type from task id: #define KE_TYPE_GET(ke_task_id) ((ke_task_id) \u0026 0xFF) \nRetrieves task index number from task id: #define KE_IDX_GET(ke_task_id) (((ke_task_id) \u003e\u003e 8) \u0026 0xFF)"},"102":{y:0,u:"../Content/firmware_reference/fwref_Bluetooth_LP.htm",l:-1,t:"Bluetooth Stack",i:0.000447713649571742,a:"Bluetooth Stack Some of the material in this topic has been adapted with permission from CEVA documentation. This chapter is intended to complement the CEVA API documentation included with your RSL15 install. Consult this documentation when API function information cannot be found in the CEVA documentation. This topic explains how the Bluetooth stack, including the HCI (host/controller interface), GATT (generic attribute profile), and GAP (generic access profile), is implemented for RSL15. This chapter also provides a description of the Bluetooth profile libraries that are provided with the RSL15 system to support standard use cases. For more information about this topic, see:"},"103":{y:0,u:"../Content/firmware_reference/fwref_Bluetooth_Intro.htm",l:-1,t:"Introduction",i:0.00115578363899366,a:"Include and Object Files The Bluetooth stack is accessed through the ble.h header file. This header is supported by a set of include files located in the include\\ble folder of the installation. \n\n The stack is extended by a number of GATT-based profiles and services. The headers for these profiles are located in the include\\ble\\profiles folder, and a list of the available supporting objects is provided in the  \"Bluetooth GATT-Based Profile and Service Object Files\" table . All of the individual profile libraries use the Bluetooth Low Energy stack through the profile’s specified interfaces. These interfaces are documented in the interface specifications. Because the Bluetooth Low Energy stack itself requires a reciprocal link in order to find all of the profile components, the stack library has been built with an object factory that instantiates calls to each of the profiles. If a profile is used by an application, the Bluetooth stack needs to use the specified profile library. ..."},"104":{y:0,u:"../Content/firmware_reference/fwref_Bluetooth_HCI.htm",l:-1,t:"HCI",i:0.00298346005075112,a:"The role of the HCI is to provide a uniform interface method of accessing a Bluetooth Low Energy controller’s capabilities from the host. The HCI layer is part of the Bluetooth Low Energy protocol stack, as shown in the  \"Bluetooth Low Energy Protocol Stack\" figure . Bluetooth Low Energy Protocol Stack The Bluetooth stack optionally provides an HCI layer, which provides direct access to the stack at an interface between the host and controller layers. The role of the HCI is to convey the information from one\nlayer to the other by following the rules defined in the HCI portion of the Bluetooth standard. As shown in the sample code, the RSL15 HCI layer implementation can be used to interface with a transport layer that manages the reception and transmission of messages over a UART physical interface. As shown in the  \"HCI Working Modes\" figure , the two main configurations are supported by the HCI software. HCI Working Modes RSL15 has both a full stack system, and compatibility providing ..."},});