define({"968":{y:0,u:"../Content/security_users_guide_rsl15/sug_EHState_SecurityFeatures.htm",l:-1,t:"EH_STATE Security Features",i:0.00166122182255225,a:"Overview Devices are delivered from manufacturing in the Energy Harvesting state (EH_STATE) by default, and hence also in the corresponding life cycle state LCS_EH. When in LCS_EH, it is possible to implement a lightweight security model which allows the device to be locked, preventing unauthorized access to the code or stored secrets. In order to lock a device in LCS_EH, a device must be provided with a key and the debug control unit (DCU) lock bit values. These two pieces of information combine to ensure only the required debug facilities are allowed in normal operation. At the same time, it still allows the device to be unlocked, which is achieved by providing the correct key through a defined port. It is also possible to transition a device from LCS_EH to the more secure life cycle states by revoking the state. When in LCS_EH, the following facilities are available: Configuration Updates Provide a key to the device allowing debug access when the device is locked. This is a 128-bit ..."},"969":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_LP.htm",l:-1,t:"Secure Root of Trust State (ROT_STATE)",i:0.000447713649571742,a:"Secure Root of Trust State (ROT_STATE) The ROT_STATE is provided to support applications where the security of the system needs to be much stronger than in EH_STATE. For more information about this topic, see:"},"970":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_Features.htm",l:-1,t:"ROT_STATE Features",i:0.000447713649571742,a:"The ROT_STATE provides: A managed life cycle for devices, ensuring that only specific functionality is available in each life cycle state (LCS) Some features, such as debug access, are turned off by default in certain life cycle states. If a feature is required in a specific LCS that has been disabled, it can be granted using cryptographically secure certificates. A secure boot facility whereby any firmware being executed by the ROM must be cryptographically verified and authenticated Secure debug facilities where the debug port can only be enabled via the use of cryptographically secure certificates A secure storage area for assets that are used to control the LCS behavior, and includes such items as:   The RoT hash, provisioning key, and code encryption key are specific to each RoT in the system. RSL15 supports two distinct Roots of Trust. The Root of Trust (RoT) hash value, which allows for certificate authentication (HBK0/1) The storage of provisioning keys, to allow secure assets ..."},"971":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_ChipMfState.htm",l:-1,t:"Chip Manufacture State (LCS_CM)",i:0.000447713649571742,a:"LCS_CM is defined as the chip manufacture state, and is the default state when the NVM is empty. In this state, the debug port is open and firmware may be loaded to the board. There is no Root of Trust programmed in the system, so applications can not yet be authenticated against a known identity. However, it is possible to ensure that they are internally consistent and have not been corrupted. This state has features very similar to the EH_STATE/LCS_EH, but has no facility to lock the debug port yet. It is not intended for delivery to end users; it is for performing initial application debugging and testing, and allows initial provisioning of the Initial Chip Vendor (ICV) Root of Trust. The act of provisioning the ICV (Initial Chip Vendor) data establishes the first Root of Trust in the system. LCS_CM to LCS_DM Transition To transition a device from LCS_CM to LCS_DM, specific information needs to be created and written to the NVM. Once this data is written, the device powers up in the ..."},"972":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_DeviceMfState.htm",l:-1,t:"Device Manufacture State (LCS_DM)",i:0.000447713649571742,a:"LCS_DM is defined as the device manufacture state, and is the only valid state after LCS_CM. In this state, the debug port is locked by default, and debug certificates must be provided to open the debug port. The use of debug certificates is explained in  Secure RoT Resources . It is expected in LCS_DM that the ICV Root of Trust has been programmed in the system. In this state, any application firmware being executed as part of the secure boot process must be validated and authenticated against the HBK0 identity. This state is not intended for delivery to end users. It is provided for performing initial application debugging and testing, and to allow initial provisioning of the Original Equipment Manufacturer (OEM) Root of Trust. The act of provisioning the OEM data establishes the second Root of Trust in the system. LCS_DM to LCS_SE Transition This transition is very similar to the LCS_CM to LCS_DM transition and requires very similar data to be provided. In order to transition a ..."},"973":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_SecureState.htm",l:-1,t:"Secure State (LCS_SE)",i:0.000447713649571742,a:"The LCS_SE or secure state is the expected state for devices being delivered to final customers. In this LCS, all debug port is locked by default and application firmware must be authenticated prior to execution. Verification or authentication failures result in the device entering a failure state and no application being executed. The only valid life cycle transition from this state is to LCS_RMA, which requires authentication from both the ICV and OEM RoTs. LCS_SE to LCS_RMA and LCS_DM to LCS_RMA The transition to LCS_RMA state follows the same process, whether it originates from LCS_DM or LCS_SE. This transition is handled after the devices have been manufactured, so the process is different from the provisioning processes outlined for previous LCS transitions. When transitioning to LCS_RMA, the expectation is that the device has an issue and must be returned to the manufacturer for fault analysis. The device could be coming from the secure state,  so its firmware might not be able ..."},"974":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_ReturnMerchState.htm",l:-1,t:"Return Merchandise Authorization State (LCS_RMA)",i:0.000447713649571742,a:"Return Merchandise Authorization State (LCS_RMA) In the RMA LCS, the device is destined to be returned to the manufacturer. This state is irrevocable; the device must not be used when in this state. This state allows application firmware to be executed if it can be verified and authenticated via one of the RoTs. Any secret keys stored in the NVM have been erased, so it is not possible to perform any application decryption or use any secured assets. Debug port is opened to allow fault analysis by the manufacturer. If a device manufacturer wishes to ensure that the application code cannot be executed in RMA, the device certificates which form the RoT verification must be erased. If a device manufacturer wishes to ensure that the application code cannot be read, the flash memory must be erased once the device has transitioned to the RMA state."},"975":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_ROTConstraints.htm",l:-1,t:"ROT_STATE Constraints",i:0.000447713649571742,a:"Because of the nature of the ROT_STATE design, there are several constraints that need to be considered: The authentication and verification of firmware executing on the device is a fairly complex process, and as such, slows down the system’s initial boot time. This does not affect wakeup time from sleep modes. Only signed code can be executed by the ROM; if the verification or authentication fails, the ROM enters a failure state. The Secure Boot features are embedded in the ROM and hardware of the system; they can only be changed on a cold reset of the device. Therefore, it is not possible to start a debug session on an active device if the debug certificates have not already been loaded. Life cycle state changes can only occur on a cold reset of the system. The managed life cycle model ensures that once a life cycle transition has been made, it cannot be reversed. The managed life cycle model includes a Return to Manufacture (RMA) state. This requires authorization from all Roots of ..."},"976":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_RootsOfTrust.htm",l:-1,t:"Roots Of Trust (RoTs)",i:0.00416282450266307,a:"Overview RSL15 provides facilities to support two independent hardware Roots of Trust (RoTs). A Root of Trust provides a secure mechanism to verify that code being executed on the device has been verified and authenticated. Verification involves checking that the firmware image being executed has not been corrupted. It uses a cryptographic signature to verify that the code is correct. Authentication involves checking that the firmware image has been provided by a trusted party, by ensuring that the key used to sign the image is actually owned by the firmware provider. The authentication process uses asymmetric encryption where the public key is known to the device and the private key is used to sign the image. In this way, the system can guarantee that the image has been signed by someone authorized to sign the firmware, and that the image has not been tampered with or corrupted. In RSL15, the information required to enable this process is held in hardware and in the secure processing ..."},"977":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_SecureROTResources.htm",l:-1,t:"Secure RoT Resources",i:0.00872318415614752,a:"Certain configuration items are required for supporting the correct operation of the Secure RoT. These are split into three broad categories, as follows: Configuration items held in secure NVM storage Certificates and other configuration items supporting secure boot Certificates required to support secure debug Understanding how these items relate to each other, and what is needed at which stage of the product life cycle, is important to your implementation of the security system. NVM Storage The NVM is protected by the Arm CryptoCell-312 security block; only certain parts of the NVM can be read or written at any given point in the device life cycle. This is normally managed during device provisioning either from LCS_CM → LCS_DM, or from LCS_DM → LCS_SE. The  \"Asset Storage in NVM\" table  describes the assets that are stored in NVM. Additional Information For both the ICV and OEM provisioning operations, the following items are required: RSA Public/Private key pair This forms the basis ..."},"978":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_SecureBootFlow.htm",l:-1,t:"Secure Boot Flow",i:0.00416282450266307,a:"The secure boot process in ROT_STATE follows a similar structure to the boot process in EH_STATE, but adds verification and authentication steps to the flow. Application Signing Application signing, described in  Secure Boot Flow , provides the basic components that allow the ROM to verify and authenticate the application. The flow chart in the  \"Secure Boot Process\" figure  gives a high level overview of this process. Secure Boot Process As can be seen from the flow, any failures in the verification and authentication stages result in the device being locked and no application code being executed. This ensures that the device only operates correctly if valid application code is loaded. Note that the \u0027No\u0027 path following the \"LCS Valid?\" check, as shown in the  \"Secure Boot Process\" figure , causes the system to lock up completely in situations where the security block cannot be initialized correctly or the LCS is in an invalid state. In these situations the device has detected a ..."},"979":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_SecureDebugFlow.htm",l:-1,t:"Secure Debug Flow",i:0.000624731146927222,a:"The mechanisms for handling debug certificates are very similar to the mechanisms for handling the key and content certificates mentioned in  Secure Boot Flow . However, in this case, rather than deciding if an application is valid to be executed, the purpose of the debug certificate chain is to configure the debug port and other features governed by the Debug Control Unit (DCU). As indicated in  Secure RoT Resources , the debug certificate chain normally consists of the following: A key certificate which has been signed with a private key associated with a specific RoT in the system The key certificate is optional, as it is possible instead to sign the debug enabler certificate with the RoT private key. However, this is not recommended. A debug enabler certificate that identifies which specific DCU bits can be unlocked, and the LCS of the device being debugged A debug developer certificate that identifies the requested DCU bits being unlocked and the SOC ID of the device being ..."},"980":{y:0,u:"../Content/security_users_guide_rsl15/sug_ROTState_SecureApps.htm",l:-1,t:"Secure Applications",i:0.000624731146927222,a:"Application Signing Application signing is described in  Application Signing . The Key and Content certificates are described in  Types of Certificate . Application Configuration Block The application configuration  block is a single contiguous block of memory at a fixed location in flash. For RSL15 this is located at the base of the data flash, at address 0x00158000. The layout of the configuration block is shown in the  \"Application Configuration Block Layout\" figure : Application Configuration Block Layout Where: Address of first key certificate Defines the base address of the first key certificate in a three-certificate Root of Trust chain If the system is using a two-certificate Root of Trust chain, this address value needs to be set to 0xFFFFFFFF. Address of second key certificate Defines the base address of the second key certificate in the Root of Trust chain Address of content certificate Defines the base address of the content certificate associated with the application ..."},"981":{y:0,u:"../Content/security_users_guide_rsl15/sug_DebugCertContstr_LP.htm",l:-1,t:"Debug Certificate Loading Process And Constraints",i:0.00106000773949536,a:"In both the EH_STATE and ROT_STATE there are concepts of application configuration and debug certificates. These are blocks of data in fixed locations which are reserved for use by the ROM. The actual usage and layout of these data blocks are different in the two states. EH_STATE In EH_STATE the application configuration is optional allowing the image to be located away from the base of flash. If the application configuration block is not available or not valid, the ROM boots by default from the base of flash memory if a suitable application exists there. The debug certificate in EH_STATE consists of a single reserved area of memory held in a single 256-byte sector of Data Flash. ROT_STATE The application configuration data is mandatory in ROT_STATE as it defines the memory locations of the various Root of Trust certificates and hence allows the RoT to be established. The debug certificates, if present, are stored in a reserved block of memory held in contiguous sectors of data flash. ..."},"982":{y:0,u:"../Content/security_users_guide_rsl15/sug_DebugCertContstr_ResSpace.htm",l:-1,t:"Reserving Space for the Application Configuration Block and Debug Certificates",i:0.00298346005075112,a:"Reserving Space for the Application Configuration Block and Debug Certificates On RSL15, the application configuration and debug certificates are held in data flash in consecutive sectors. (Data flash in RSL15 has a sector size of 256 bytes.) One sector for the application configuration One sector for the EH_STATE debug certificate Ten sectors for the ROT_STATE debug certificates Therefore, a total of 3 KB are reserved for use by the different security mechanisms. The layout of this is shown in the  \"Reserved Space for Security Mechanisms\" figure . Reserved Space for Security Mechanisms"},"983":{y:0,u:"../Content/security_users_guide_rsl15/sug_DebugCertContstr_LoadDebugCert.htm",l:-1,t:"Loading Debug Certificates to a Device",i:0.000447713649571742,a:"When trying to debug a secure device, the initial condition is naturally that the debug port are locked; therefore some other mechanism is required in order to get the debug certificates into the device. In normal operation, it is possible that the debug certificates could be loaded to the device via a serial port, via an over-the-air connection, or some other way specific to a users application. All these methods, however, require that the application firmware on the device is working well enough to support the transfer and storage of the certificates. As a default mechanism, RSL15 allows the use of the Data Exchange Unit (DEU) to transfer data into and out of the device in a strictly controlled form. This feature has been provided with the express purpose of being able to create debug developer certificates and have the packages loaded into the device in a securely managed manner. The DEU may be used in either EH_STATE or ROT_STATE to perform the following operations: Retrieve the ..."},"984":{y:0,u:"../Content/security_users_guide_rsl15/sug_DebugCertContstr_DEU.htm",l:-1,t:"The Data Exchange Unit (DEU)",i:0.00298346005075112,a:"The DEU is explained in more detail in the Hardware Reference Manual, however for the purposes of this document it can be thought of as a secure communications channel which is managed by the hardware and ROM in the device. It provides limited, strictly-controlled features and is not accessible outside of the ROM. Data Exchange Flow The DEU communication is managed by the ROM and the hardware in the device. This is a secure channel that  causes a cold reset on the first attempt to access it, hence passing control to the ROM to perform any interaction. On completion of the interaction with the device it again causes a cold reset, allowing the ROM to re-evaluate the Root of Trust and debug requirements in the system. In this way, no application code may access the DEU as the ROM ensures that the communication is controlled. This process is demonstrated in the  \"Data Exchange Flow\" figure : Data Exchange Flow Data Exchange Unit Protocols As can be seen from the diagram above, the DEU ..."},"985":{y:0,u:"../Content/security_users_guide_rsl15/sug_Tools_LP.htm",l:-1,t:"Security Tool Support",i:0.00115378684465349,a:"Security Tool Support This topic describes RSLSec, a utility to help manage the transitions through all of the device states and life cycle states. The example commands given throughout this topic are intended as a tutorial.  For more information about this topic, see:"},"986":{y:0,u:"../Content/security_users_guide_rsl15/sug_Tools_GetStarted.htm",l:-1,t:"Getting Started",i:0.00082828988299581,a:"Overview Many operations are possible when using the security features of an RSL device, including state transitions, life cycle transitions, debug support, application signing, and more. The RSL Security Tooling (RSLSec) application is designed to make RSL15 security features and their usage as straightforward as possible. RSLSec consists of two parts: A PC-based component which handles the following general operations: Creation of keys Signing of applications Generation of RoT hashes Generation of key and content certificates Generation of debug certificates Management of the process enabling debug of secure devices Management of the transition to RMA state An embedded application, used to perform specific life cycle transitions and associated asset provisioning: EH → CM (Effectively, revocation of LCS_EH) CM → DM  DM → SE  DM → RMA SE → RMA These two tools combine to meet the needs of RSL devices in all life cycle states. Software Installation RSLSec is distributed as a single ..."},"987":{y:0,u:"../Content/security_users_guide_rsl15/sug_Tools_EHConfigUse.htm",l:-1,t:"EH State Configuration And Usage",i:0.000447713649571742,a:"Overview Devices delivered from manufacturing are by default in the Energy Harvesting state (EH_STATE), and therefore, in the corresponding life cycle state LCS_EH. When in LCS_EH, it is possible to implement a lightweight security model that allows the device to be locked, preventing unauthorized access to the code or stored secrets. To lock a device in LCS_EH, the device must be provided with a key and the DCU bit values. These two pieces of information combine to ensure that only the required debug facilities are allowed in normal operation, while also allowing the device to be unlocked when the correct key is provided via a defined port. It is also possible to transition a device from LCS_EH to the more secure life cycle states by revoking the state. When in LCS_EH, the following facilities are available: Configuration Updates Provide a key to the device, allowing debug access when the device is locked. This is a 128-bit value, which might be unique to each physical device or might ..."},"988":{y:0,u:"../Content/security_users_guide_rsl15/sug_Tools_ROTMode.htm",l:-1,t:"RoT Secure Mode Configuration And Usage",i:0.00144058397291943,a:"This section details the steps required to establish a secure Root of Trust in a new device that has had its EH signature revoked. Provisioning Process Provisioning a device involves updating the specific fields in the NVM that cause life cycle state transitions. Provisioning is used to move a device in ROT_STATE from LCS_CM to LCS_DM, and then to LS_SE. Transitioning to RMA is outside the scope of the provisioning process. Provisioning normally happens in two places: The ICV (initial chip vendor) owner uses the Krtl of the device to provision some secret information to the NVM and transition the device from LCS_CM to LCS_DM. The OEM owner requires a safe form of the Krtl to provision their own secrets to the device, and to transition it from LCS_DM to LCS_SE.  The  \"Provisioning Process Overview\" figure  demonstrates this process. Provisioning Process Overview The approach shown in the  \"Provisioning Process Overview\" figure  is the general case where the ICV, OEM, and onsemi are ..."},"989":{y:0,u:"../Content/security_users_guide_rsl15/sug_Tools_EHtoROT.htm",l:-1,t:"Transition from EH_STATE to ROT_STATE",i:0.000447713649571742,a:"Revoking EH_STATE Revoking access to the EH_STATE is straightforward and follows a similar process to that outlined for other EH_STATE operations. There are no options specific to this command (though the options common to all commands are still applicable). The revocation action cannot be reversed once it has completed. Example Usage c:\\Development\\RSLSec\u003erslsec eh revoke --write This command connects to an RSL15 device and update the EH_STATE configuration to render it invalid. On completion, the device is reset and has transitioned to ROT_STATE in LCS_CM. This action is not reversible. High level help from \u0027RSLSec eh revoke --help\u0027 c:\\Development\\RSLSec\u003erslsec eh revoke --help\n //usage:  RSLSec eh revoke [-h] [--out OUT] [--target TARGET] [--write] //Revoke LCS_EH, transition to LCS_CM //optional arguments:   -h, --help       show this help message and exit   --out OUT        File to which the loadable package is being written   --target TARGET  Target connection [RSL15]   --write   ..."},"990":{y:0,u:"../Content/secure_bootloader/sboot_LandingPage.htm",l:-1,t:"Secure Bootloader Guide",i:0.00094911010245856,a:"Secure Bootloader Guide This group of topics describes the functionality and usage of the secure bootloader with RSL15, along with Platform Security Architecture (PSA) compliance, secure storage, and attestation. RSL15 includes a secure bootloader sample application which can be used by developers to acquire familiarity with the secure bootloader.                                                "},"991":{y:0,u:"../Content/secure_bootloader/sboot_Overview_LP.htm",l:-1,t:"Overview",i:0.000624731146927222,a:"Overview The secure bootloader for RSL15 is a reference application, called secure_bootloader, which can be used to develop an end product bootloader that operates in a secure manner. The application has the following four modes providing increasing levels of secure operation, available as needed depending on the end product\u0027s use cases: Basic bootloader (non-secure) Secure bootloader (maintains authenticated Root of Trust set up by the ROM) Secure bootloader with secure storage Secure bootloader with secure storage and device attestation More detailed information about these four modes is found in Chapter 1 \"RSL15 Secure Bootloader Usage Options\" on page 1 For more information about this topic, see:"},"992":{y:0,u:"../Content/secure_bootloader/sboot_Overview_CommonFeatures.htm",l:-1,t:"Common Features",i:0.000568533869034493,a:"The four modes of operation build on each other, with available features in one also being available for the next level. For example, all  secure bootloader functionality is still available when using the secure storage mode of operation. This is indicated in the  \"Bootloader Options\" figure . Bootloader Options The bootloader divides the main flash memory into two areas: the app download area and the app execution area. This division provides a starting point for users who want to use the bootloader for firmware update purposes. The bootloader application is the first application entry point after reset. It is located at the base address of the main flash (0x00100000). Upon start, the bootloader checks the app download area for a valid boot image. This application can be a regular application, or a new bootloader. If there is one, the bootloader copies/overwrites this image into the app execution area, invalidates the data in the download area, and boots this new image. If no valid ..."},"993":{y:0,u:"../Content/secure_bootloader/sboot_BootUsageOpt_LP_Options.htm",l:-1,t:"RSL15 Secure Bootloader Usage Options",i:0.000447713649571742,a:"Functionality Access Options The RSL15 secure bootloader sample application includes the following options for accessing increasing levels of functionality depending on the end product needs: Basic bootloader functionality Secure bootloader with support for providing authenticated and validated loading of applications in addition to the bootloader itself Authenticated transport layer Authenticated images verified on load Authenticated images verified again prior to overwriting an existing image Authenticated images booted by the bootloader Secure storage A limited area of flash memory that is allocated as secure storage Enables the storage and retrieval of encrypted assets Simple filing system that also provides storage for general secure storage in addition to asset storage Attestation Support for the injection or creation of attestation keys Attestation keys are stored in secure storage. A public key can be requested from application code using the bootloader interface. Support for ..."},"994":{y:0,u:"../Content/secure_bootloader/sboot_Overview_MemoryPartitioning.htm",l:-1,t:"Memory Partitioning Overview",i:0.00298346005075112,a:"Depending on the feature set used by the bootloader, the amount of flash memory it occupies can change. This allows a bootloader with a lower feature set to be used in cases where, for instance, the Root of Trust or secure storage is not required. When a reduced feature set bootloader is used, the memory partitioning can be changed, allowing for larger user applications to be loaded. For illustrative purposes, the  \"Build Configuration Memory Sizes\" table  shows the expected sizes of each optional build configuration, with expected allocations of memory for application and download areas depending on build options. The precise values are subject to change depending on the actual optimization levels and feature sets you select, but this provides some guideline figures to help you decide which configuration to use.  Derivation of these start addresses and sizes is available in bl_memory.h; this information is output to the RTT Viewer when debugging the secure bootloader in the onsemi IDE ..."},"995":{y:0,u:"../Content/secure_bootloader/sboot_PSAComp_LP.htm",l:-1,t:"PSA Compliance Background",i:0.000447713649571742,a:"PSA Compliance Background The RSL15 secure bootloader is a reference implementation that can be used with associated guidelines to achieve a product that is compliant with Platform Security Architecture (PSA). The RSL15 secure bootloader sample application can be adapted as needed and incorporated into an overall firmware solution. See  https://www.psacertified.org/  for the full background on the PSA certification requirements and components. An overview and the specific implementation details for RSL15 are provided here. For more information about this topic, see:"},"996":{y:0,u:"../Content/secure_bootloader/sboot_PSAComp_Overview.htm",l:-1,t:"Overview of PSA Compliance",i:0.00144058397291943,a:"PSA is a concept originated by Arm and managed by third party labs and certification authorities, with the goal of standardizing the security methods across the varying types of connected devices in the semiconductor industry. It provides established best practices, as well as documentation and methods to determine whether a given device meets the outlined standards. PSA protects sensitive assets (keys, credentials and firmware) by separating them from the application firmware and hardware. It defines a Secure Processing Environment (SPE) for this data, the code that manages it, and its trusted hardware resources. The  \"Updatable and Immutable Areas\" figure  shows the updatable and the immutable (non-changable) parts of an RSL15-based system that is intended for PSA compliance and follows the PSA Device Model guidelines. This clearly shows the secure bootloader in relation to the other parts of the system. The secure bootloader forms part of the chip scope, but is also part of the ..."},});