define({"997":{y:0,u:"../Content/secure_bootloader/sboot_BasicFunc_LP.htm",l:-1,t:"Basic Bootloader",i:0.000568533869034493,a:"Basic Bootloader The secure bootloader can be used as a non-secure bootloader if the security features are not needed. In this case, the bootloader provides the following features: Booting of an application from flash Updating to store a new application in flash Updating the bootloader For more information about this topic, see:"},"998":{y:0,u:"../Content/secure_bootloader/sboot_BasicFunc_Usage.htm",l:-1,t:"General Usage",i:0.000624731146927222,a:"The bootloader must be loaded onto the device. An application to be used with the bootloader must have its start address in the location expected by the bootloader. See  Overview  for more information. The  \"Standard Load and Update Sequence\" figure  illustrates the process for updating the application stored in flash. Standard Load and Update Sequence Each request has a frame consistency sequence on it (a simple CCITT CRC of the data in the request). A block load request includes the length of the application being loaded, and the CRC32 for the whole application. Once a number of blocks have been loaded, the CRC32 is checked to ensure that no frames have been lost or corrupted during transmission. At any stage, if an error is detected (e.g., a timeout or a bad frame), the load process terminates with an END message and an indicator of the reason for the failure. The application used in the firmware update process must include bootloader.h and use SYS_BOOT_VERSION to set the version ..."},"999":{y:0,u:"../Content/secure_bootloader/sboot_SecureBoot_LP.htm",l:-1,t:"Secure Bootloader",i:0.000568533869034493,a:"Secure Bootloader The secure mode of the bootloader provides the following features: Booting of a secure application from flash Updating to store a new secure application in flash Updating the secure bootloader Support for PSA (Platform Security Architecture) level 1 compliance For more information about this topic, see:"},"1000":{y:0,u:"../Content/secure_bootloader/sboot_SecureBoot_BootSecApp.htm",l:-1,t:"Booting a Secure Application",i:0.000447713649571742,a:"Booting a Secure Application The secure bootloader provides firmware integrity and authenticity validation during a secure or trusted boot process. The main interface consists of an initialization function and a function to authenticate a Root of Trust certificate chain based on a given Root of Trust. blSecureBootStatus_t BL_SecureBootAuthenticate(     uint32_t opkey1, uint32_t opkey2, uint32_t opcontent,     bool verifyImages, uint32_t relocation);"},"1001":{y:0,u:"../Content/secure_bootloader/sboot_SecureBoot_UpdateSecApp.htm",l:-1,t:"Updating a Secure Application",i:0.00298346005075112,a:"When a secure application must be updated, the process is as follows: Request an update. The bootloader polls a flag to determine if an update is requested, so this must be set. BL_UpdateType_t BL_UpdateIsAvailable(uint32_t address, uint32_t extent); Provide a new secure application. The bootloader checks if there is a new image in the download area. BL_UpdateType_t BL_UpdateIsAvailable(uint32_t address, uint32_t extent); Update the image. The bootloader uses the function with this prototype to perform the update. void BL_UpdateImage(BL_UpdateType_t request, uint32_t srcAddress, uint32_t dstAddress, uint32_t dstLength); The application must also be authenticated. There are options to share a Root of Trust between the secure application and secure bootloader, such that a tradeoff can be made between boot time and the level of security needed. Alternatively, they can use separate Roots of Trust for increased security, but with increased boot time. The sequence is shown in the  \"Secure ..."},"1002":{y:0,u:"../Content/secure_bootloader/sboot_SecureBoot_UpdateSecBootloader.htm",l:-1,t:"Updating the Secure Bootloader Itself",i:0.000447713649571742,a:"Updating the Secure Bootloader Itself Updating the secure bootloader itself is much the same as updating a secure application. It uses the same function but with a different image. Flags are used for differentiation between a basic bootloader and a secure bootloader to determine the image size needed, since the secure bootloader uses more memory. To prepare a secure bootloader, take the following steps: Ensure that you have, or make sure to create, all the necessary keys and key certificates. See the  RSL15 Security User\u0027s Guide for details on creating secure applications. Create a content certificate based on the key certificates. Sign the image using the created certificates. The new bootloader must be fully validated prior to switching to it, so that a complete copy is held in memory."},"1003":{y:0,u:"../Content/secure_bootloader/sboot_SecureBoot_Immutable.htm",l:-1,t:"Support for Immutable Portions in the Secure Bootloader",i:0.000447713649571742,a:"Support for Immutable Portions in the Secure Bootloader The concept of updateable and immutable portions of a secure processing environment is introduced in  Overview of PSA Compliance . RSL15 has the following support for the immutable portions of the secure processing environment: A boot ROM that can handle a Secure Boot and Secure Debug process Hardware isolation of cryptographic functions and the storage of security-related assets Unique key storage and the concept of a hardware unique key A managed security life cycle as described in the  RSL15 Security User\u0027s Guide Trusted subsystems providing a separation between the secure and non-secure environments, using TrustZone"},"1004":{y:0,u:"../Content/secure_bootloader/sboot_SecStorage_LP.htm",l:-1,t:"Secure Storage",i:0.000447713649571742,a:"Secure Storage Protected storage is required to hold the keys and any other context that must be maintained. Any secure code has free access to the contents of the secure storage area. For more information about this topic, see:"},"1005":{y:0,u:"../Content/secure_bootloader/sboot_SecStorage_Area.htm",l:-1,t:"Secure Storage Area",i:0.000447713649571742,a:"Secure Storage Area The bootloader\u0027s sections.ld file shows the size and start address of the secure storage area: /* Reserve the remaining 11K from the first data sector for secure storage */  BL_SECURE_STORE (xrw)   : ORIGIN = 0x0015A400, LENGTH = 11K"},"1006":{y:0,u:"../Content/secure_bootloader/sboot_SecStorage_ContentStored.htm",l:-1,t:"Content to be Stored in Secure Storage",i:0.000447713649571742,a:"Content to be Stored in Secure Storage RSA public/private key pair ECC public/private key pair AES key"},"1007":{y:0,u:"../Content/secure_bootloader/sboot_SecStorage_API.htm",l:-1,t:"API",i:0.000447713649571742,a:"API The API for secure storage is defined in bl_simple_filer.h and bl_file_encryption.h. The former provides the basic file system handler, and the latter provides the encryption layer. See the API reference or the files in the sample implementation for details.  Some important functions are as follows. From bl_simple_filer.h: BL_FStoreStatus_t BL_FStoreWrite(BL_FSFileId_t id, uint8_t *buffer, uint16_t size, uint16_t flags); BL_FStoreStatus_t BL_FStoreWrite(BL_FSFileId_t id, uint8_t *buffer, uint16_t size, uint16_t flags); BL_FStoreStatus_t BL_FStoreDelete(BL_FSFileId_t id);   BL_FStoreStatus_t BL_FStoreFileList( uint8_t *buffer, uint16_t *maxsize, bool showHidden); From bl_file_encryption.h: BL_EncryptionStatus_t BL_EncryptBuffer(uint8_t *buffer, size_t length);   BL_EncryptionStatus_t BL_DecryptBuffer(uint8_t *buffer, size_t length);"},"1008":{y:0,u:"../Content/secure_bootloader/sboot_SecStorage_BasicOp.htm",l:-1,t:"Basic Operation",i:0.000447713649571742,a:"The secure bootloader offers a simple file system, primarily for storing attestation keys, but it can also be used for the general storage of small files. The file system location is defined in bl_memory.h and occupies a range of sectors in data flash. Due to the limitations of the flash, the file system space is set to 11 KB. The file system is organized in blocks that align with the underlying data sectors. Each data sector is 256 bytes in length; therefore, 44 blocks are available for use. A single file can be stored in more than one block. A single block can only contain information for a single file. The first sector contains the inode table, which describes the blocks that are allocated to each file. There is a single inode entry for each file held in the file system. Each inode is defined as 12 bytes; therefore, a maximum of 21 files are supported by the file system. Each inode/file contains the following information: The list of blocks allocated to the file. This is a 48-bit ..."},"1009":{y:0,u:"../Content/secure_bootloader/sboot_Attest_LP.htm",l:-1,t:"Attestation",i:0.000568533869034493,a:"Attestation Attestation, in this context, refers to providing information about the device to other parties using a very simple, cryptographically secured token; this is part of PSA compliance. Attestation provides  a device with the ability to sign an array of bytes with a device private key and return the result to the caller. There are several use cases, ranging from attestation of the device state to generating a key pair and proving that it has been generated inside a secure key store. For more information about this topic, see:"},"1010":{y:0,u:"../Content/secure_bootloader/sboot_Attest_Overview.htm",l:-1,t:"Overview and Background",i:0.000447713649571742,a:"Overview and Background To maintain the Root of Trust, the secure bootloader only lets you program the device if you prove that you are allowed to do so. A challenge and response process matches certificates; if you do not have a matching certificate, it is not possible for you to program the device. Part of attestation is the Entity Attestation Token (EAT), which contains claims that are generated in the device RoT. EAT token generation is expected to be performed many times, possibly for each transaction. It is relatively inexpensive because the claims data is small and ECDSA signing is relatively fast. For further details about the EAT, see  Attestation Token . The token is sent to the device, and then goes to the relying party, which then relays it (without examining or modifying it) to the attestation service for verification."},"1011":{y:0,u:"../Content/secure_bootloader/sboot_Attest_Interface.htm",l:-1,t:"Attestation Interface",i:0.00298346005075112,a:"The PSA Attestation API is a standard interface provided by the PSA Root of Trust. For attestation within the context of PSA, the key can be generated or injected into the system. For the RSL15 secure bootloader sample application, there is a function to inject a key. If the application is not given an injected key, it creates and internal key.  The main relevant functions for the RSL15 attestation interface are as follows:\n\n     Inject attestation key Get attestation token Get attestation token size A summary and the prototypes of the attestation interface functions are provided below. See the relevant parts of the full API and the bl_attestation.h header file for further details on function parameters. Key Injection The key injection interface allows for the injection of keys generated externally to the device. It also allows for keys to be generated on the device and then stored for later use. AES keys are derived from the HUK (Hardware Unique Key) using some form of initial value. ..."},"1012":{y:0,u:"../Content/secure_bootloader/sboot_Attest_Token.htm",l:-1,t:"Attestation Token",i:0.00959782893094156,a:"Format of Token The attestation token takes the format of what is becoming an industry standard: an entity attestation token (EAT). For the purposes of this sample code, a variant of the Arm Platform Security Architecture attestation token has been chosen to provide the basic structure. More information is available at:  https://www.psacertified.org/blog/what-is-an-entity-attestation-token/ . An EAT is a small blob of data that includes information items and is cryptographically signed. The signing secures the token itself, so that the mechanism that is transmitting the token does not have to provide any security. This allows IoT devices to securely introduce themselves to networks and to IoT platforms. The EAT is wrapped into a compact binary object representation (CBOR)-type message. Each information item in this token in known as a claim, as shown in the  \"Items Included in Token\" table . A claim is a data item, which is represented as a key-value pair. The size of the attestation ..."},"1013":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg.html",l:-1,t:"Secure Bootloader Sample Reference",i:0.000447713649571742,a:"  Secure Bootloader Sample Reference. Summary   Typedefs BL_FCS_t  : Define a FCS type. BL_FSFileId_t  : Define a file identifier as a sixteen bit word. BL_BootAppId_t  : Define the application ID as a six character string.   Variables DRBGContext  : Define a CTR_DRBG context structure, used by the RNDContext. BL_ImageWorkspace  : Defines a common operation buffer for handling images.   Data Structures BL_AppConfiguration_t  : Define a structure which can map onto the configuration area. BL_ImageOperation_t  : Buffer used for loading data in chunks, allow 2 blocks. BL_ImageSplitRange_t  : define an address range which can wrap-around a reserved block BL_StatusResponse_t  : to maintain backwards compatibility, we use a two byte status for most messages. BL_BootAppVersion_t  : Define the application version as id and version details. BL_HelloResponse_t  : Define the contents of a Hello response.   Enumerations BL_AttestStatus_t  : Define the basic attestation status types. ..."},"1014":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_typedef.html",l:-1,t:"Secure Bootloader Sample Reference Typedef Documentation",i:0.0014202197349186,a:"  Secure Bootloader Sample Reference Typedef Documentation   BL_FCS_t typedef uint16_t BL_FCS_t   Location: bl_fcs.h:86   Define a FCS type.   BL_FSFileId_t typedef uint16_t BL_FSFileId_t   Location: bl_simple_filer.h:132   Define a file identifier as a sixteen bit word.   BL_BootAppId_t typedef char BL_BootAppId_t   Location: bl_versions.h:109   Define the application ID as a six character string."},"1015":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_var.html",l:-1,t:"Secure Bootloader Sample Reference Variable Documentation",i:0.000511143021809087,a:"  Secure Bootloader Sample Reference Variable Documentation   DRBGContext mbedtls_ctr_drbg_context DRBGContext    Location: bl_crypto.h:114   Define a CTR_DRBG context structure, used by the RNDContext.   BL_ImageWorkspace BL_ImageOperation_t BL_ImageWorkspace    Location: bl_image.h:119   Defines a common operation buffer for handling images."},"1016":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_struct.html",l:-1,t:"group___s_e_c_u_r_e___b_o_o_tg_struct",i:0.0017980660619469,a:"Secure Bootloader Sample Reference Data Structures Type Documentation"},"1017":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_enum.html",l:-1,t:"Secure Bootloader Sample Reference Enumeration Type Documentation",i:0.000655974622757513,a:"  Secure Bootloader Sample Reference Enumeration Type Documentation   BL_AttestStatus_t   Location: bl_attestation.h:90   Define the basic attestation status types.   Members BL_ATTEST_NO_ERROR  BL_ATTEST_INIT_FAILED  BL_ATTEST_INVALID_REQUEST  BL_ATTEST_INVALID_CLAIM  BL_ATTEST_KEY_GEN_FAILURE  BL_ATTEST_KEY_FAILURE  BL_ATTEST_BUFFER_OVERFLOW      BL_AttestKeyType_t   Location: bl_attestation.h:102   Define the types of attestation keys supported by the system.   Members BL_ATTEST_AES_128  BL_ATTEST_AES_192  BL_ATTEST_AES_256  BL_ATTEST_RSA_1024  BL_ATTEST_RSA_2048  BL_ATTEST_RSA_3072  BL_ATTEST_ECC_256  BL_ATTEST_KEYTYPE_MAX      BL_AttestationChallengeSize_t   Location: bl_attestation.h:115   Define the supported attestation challenge sizes.   Members BL_ATTEST_CHALLENGE_32 = 32 BL_ATTEST_CHALLENGE_48 = 48 BL_ATTEST_CHALLENGE_64 = 64     BL_AttestTags_t   Location: bl_attestation.h:123   Define CBOR tag values for each of the attestation fields.   Members BL_ATTEST_CBOR_TAG_HASH = ..."},"1018":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_define.html",l:-1,t:"Secure Bootloader Sample Reference Macro Definition Documentation",i:0.000888989348837381,a:"  Secure Bootloader Sample Reference Macro Definition Documentation   VT_OFFSET_STACK_POINTER #define VT_OFFSET_STACK_POINTER 0   Vector table offset for the stack pointer.   Location: bl_check.h:80   VT_OFFSET_RESET_VECTOR #define VT_OFFSET_RESET_VECTOR 1   Vector table offset for the reset vector.   Location: bl_check.h:83   VT_OFFSET_VERSION_INFO #define VT_OFFSET_VERSION_INFO 8   Vector table offset for the version information pointer.   Location: bl_check.h:86   VT_OFFSET_IMAGE_SIZE #define VT_OFFSET_IMAGE_SIZE 9   Vector table offset for the used image size pointer.   Location: bl_check.h:89   VT_OFFSET_CERT_SIZE #define VT_OFFSET_CERT_SIZE 10   Vector table offset for the certificate size.   Location: bl_check.h:92   BL_CONFIGURATION_BASE #define BL_CONFIGURATION_BASE (( BL_AppConfiguration_t  *) FLASH0_DATA_BASE)   Base address of the boot configuration in flash.   Location: bl_configuration.h:81   BL_CONFIGURATION_WORDS #define BL_CONFIGURATION_WORDS (sizeof( ..."},"1019":{y:0,u:"../Content/secure_bootloader/generated/group___s_e_c_u_r_e___b_o_o_tg_func.html",l:-1,t:"Secure Bootloader Sample Reference Function Documentation",i:0.000511143021809087,a:"  BL_AttestInitialize BL_AttestStatus_t  BL_AttestInitialize()   Initialize the attestation feature.   @returnBL_ATTEST_NO_ERROR or BL_ATTEST_INIT_FAILED.\n   Location: bl_attestation.h:139   BL_AttestAcceptKey BL_AttestStatus_t  BL_AttestAcceptKey( BL_AttestKeyType_t  keyType, size_t privKeySize, size_t pubKeySize)   Determine if it is okay to accept a key injection request.   Location: bl_attestation.h:148   Parameters   Return BL_ATTEST_NO_ERROR if the request accepted, error state otherwise.   BL_AttestFindPublicKeyHash BL_AttestStatus_t  BL_AttestFindPublicKeyHash(uint8_t * hash)   Retrieve the SHA256 hash of the public key if it exists.   Location: bl_attestation.h:156   Parameters   Return BL_ATTEST_NO_ERROR if success, otherwise an error status.   BL_AttestInjectKey BL_AttestStatus_t  BL_AttestInjectKey(uint8_t * key, size_t keySize,  BL_AttestKeyType_t  type, uint8_t * publicKey, size_t publicKeyMaxSize, size_t * publicKeySize)   Inject or create an attestation key.   If a key ..."},"1020":{y:0,u:"../Content/device_firmware_update_guide/dfu_LandingPage.htm",l:-1,t:"Device Firmware Update (DFU) Guide",i:0.000624731146927222,a:"Device Firmware Update (DFU) Guide This group of topics provides information about the tools, protocols and firmware required to perform wired and Firmware Over the Air (FOTA) firmware updates using the RSL15 Evaluation and Development Board. This guide provides an overview of the sample bootloader and its usage, includes details about the FOTA firmware images and tools, walks you step-by-step through your first firmware update using a pre-configured sample application, and shows you how to modify an existing application to support FOTA updates. These FOTA topics are intended for firmware developers who are designing and implementing RSL applications with FOTA capability.  Updating firmware is also possible with a wired connection using UART or SPI, as described in the Bootloader topic.                                          "},"1021":{y:0,u:"../Content/device_firmware_update_guide/dfu_Overview_LP.htm",l:-1,t:"Overview",i:0.000447713649571742,a:"Overview These topics provide an overview of the toolset ecosystem allowing firmware over-the-air updates, and lists the necessary prerequisites for performing them.  For more information about this topic, see:"},"1022":{y:0,u:"../Content/device_firmware_update_guide/dfu_Overview_Prereq.htm",l:-1,t:"Prerequisites",i:0.000447713649571742,a:"Prerequisites RSL15 SDK CMSIS-Pack version 1.0 or later (available at  https://www.onsemi.com/ ) RSL10 USB Dongle RSL15 Evaluation and Development Board (EVB) BLE Explorer (available at  https://www.onsemi.com/ ) Python v3.7 or later: Install package ecdsa version 0.13 or later. Install package pyserial version 3.2 or later. Make sure Python is added to the system path. You can install the above packages using PyPI (for example, python -m pip install ecdsa). The mobile application (see  RSL FOTA Mobile Application )."},"1023":{y:0,u:"../Content/device_firmware_update_guide/dfu_Bootloader_LP.htm",l:-1,t:"Bootloader",i:0.000447713649571742,a:"Bootloader The bootloader source code is provided as a sample application in the RSL15 Software Development Kit (SDK), and you can use it to create your own custom bootloader. For more information about this topic, see:"},"1024":{y:0,u:"../Content/device_firmware_update_guide/dfu_Bootloader_Overview.htm",l:-1,t:"Overview",i:0.000447713649571742,a:"Overview The bootloader is a program that can  update firmware images, initialize a device and possibly perform some sanity checks. The most important feature provided by the bootloader sample is the Firmware Over the Air (FOTA) functionality. Firmware can be loaded from a host microcontroller over UART or over the air from another wireless device using FOTA. This document describes the bootloader firmware application and development tools. It shows you: How the bootloader firmware works How to create bootloader compatible applications and firmware images for RSL15 How the bootloader protocol between the bootloader firmware and the UART updater PC tool works with the RSL15 EVB"},"1025":{y:0,u:"../Content/device_firmware_update_guide/dfu_Bootloader_Firmware.htm",l:-1,t:"Bootloader Firmware",i:0.000778670424020972,a:"The bootloader firmware application must be initially loaded onto an RSL15 device. It can be loaded via SWD/JTAG. The bootloader divides the main flash memory into two areas: the app download area and the app execution area. This subdivision provides a starting point for users who want to use the bootloader for firmware update purposes. The bootloader application is the first entry point after reset. It is located at the base address of the main flash (0x00100000) and uses the first 32 KB of memory. To be compatible with the bootloader, the linker memory map of a user application needs to be updated to add a new BOOTLOADER area and shift the application origin by 32 KB (address 0x00108000).  Vector Table Positions In addition, the boot image vector table contains two special items on positions 8 and 9, respectively: the application version descriptor and the image size. This means that modifications on the linker script (sections.ld) and the startup code (startup.S) are required to ..."},"1026":{y:0,u:"../Content/device_firmware_update_guide/dfu_Bootloader_Protocol.htm",l:-1,t:"The Bootloader Protocol For Writing Binary Files Using UART",i:0.00298346005075112,a:"The bootloader protocol on the PC side is implemented in the updater.py tool. After activating the updater mode, the PC side has to query the bootloader version, the currently installed application version, and the flash memory sector size, with the HELLO command. Then the image is transferred and programmed using the PROG command. Once the programming is complete, the device is set to application mode. A command can consist of several messages, but every message from the PC side must be confirmed by the RSL15 bootloader firmware before the PC side can send the next message. Except for the standard RESP message, every message is appended with a CCITT-CRC. RESP The standard response is a two-byte message. In the first byte the type is encoded: 0x55 stands for NEXT and 0xAA stands for END. The second byte for type = NEXT is always 0; for type = END, the second byte contains an error code: 0 = NO_ERROR 1 = BAD_MSG 2 = UNKNOWN_CMD 3 = INVALID_CMD 4 = GENERAL_FLASH_FAILURE 5 = ..."},"1027":{y:0,u:"../Content/device_firmware_update_guide/dfu_FW_LP.htm",l:-1,t:"The FOTA Firmware",i:0.000447713649571742,a:"The FOTA Firmware This topic describes the memory partitioning, setup, startup of the firmware, and updates to the application. For more information about this topic, see:"},"1028":{y:0,u:"../Content/device_firmware_update_guide/dfu_Overview_Overview.htm",l:-1,t:"FOTA Overview",i:0.00298346005075112,a:"FOTA Overview The RSL software ecosystem includes a set of tools that allows firmware over-the-air (FOTA) updates over a Bluetooth® Low Energy wireless link. On the PC side, a Python utility (mkfotaimg.py) generates FOTA-compatible firmware images, and BLE Explorer transfers the images to the remote device. BLE Explorer scans, connects and transmits the firmware image. The remote RSL device firmware side consists of a bootloader program, sample code, and a FOTA Bluetooth Low Energy stack that contains the device firmware update (DFU) Bluetooth Low Energy component. The  \"FOTA Update Setup\" figure , below, illustrates a typical FOTA update setup from the PC point of view: FOTA Update Setup"},"1029":{y:0,u:"../Content/device_firmware_update_guide/dfu_FW_FOTAPartitioning.htm",l:-1,t:"FOTA Partitioning",i:0.000778670424020972,a:"A device capable of receiving FOTA updates contains firmware composed of three parts, as illustrated in the  \"Memory Structure\" figure : Bootloader FOTA Bluetooth Low Energy stack including DFU component (fota.bin sub-image) User application (app.bin sub-image) Memory Structure For specific information about using FOTA in secure applications, see the readme file in the secure_fota_blinky sample application as well as its referenced documentation. Each part depends on the previous one, except the bootloader, which is standalone. The FOTA Bluetooth Low Energy stack depends on the bootloader. The user application depends on the FOTA Bluetooth Low Energy stack, and therefore, also depends on the bootloader. In terms of size, the bootloader reserves memory. The FOTA Bluetooth Low Energy stack contains the device firmware update (DFU) component and the padding between the sub-images. The memory available in flash for the application is the amount of memory that is left once memory is ..."},"1030":{y:0,u:"../Content/device_firmware_update_guide/dfu_FW_FWStartup.htm",l:-1,t:"Firmware Startup",i:0.000447713649571742,a:"Firmware Startup Upon boot-up, the bootloader checks whether there is a valid user application or FOTA Bluetooth Low Energy stack programmed. The sequence of operations is as follows: If there is a valid user application, start it. If no valid application is found, start the FOTA Bluetooth Low Energy stack DFU component (so the device can receive FOTA updates). If no valid FOTA Bluetooth Low Energy stack is found, start the bootloader updater (in this case, the device can only receive firmware updates over UART).  The FOTA Bluetooth Low Energy stack DFU component can be activated from the user application at any time, through a call to Sys_Fota_StartDfu(). More details about this are provided in later sections."},"1031":{y:0,u:"../Content/device_firmware_update_guide/dfu_FW_AppOnlyUpdate.htm",l:-1,t:"Application Only Update",i:0.000447713649571742,a:"To update the application, the currently installed user application needs to start the DFU component from the Bluetooth Low Energy stack. The DFU component then starts the FOTA process and receives the new application image. The application image embeds the Build ID, calculated by the GNU linker over all symbols of fota.bin (see  DFU Service Characteristics and Their Properties (table)  for more about the FOTA stack Build ID). If this information does not match the installed Bluetooth Low Energy stack revision, the FOTA update is aborted. At this point the currently installed application is not destroyed. If the FOTA Bluetooth Low Energy stack revision is compatible, the currently installed application is erased and the new image is programmed as the data comes in. When the whole image is programmed successfully, the DFU component marks the new application as valid and performs a restart. If the application update is aborted for any reason (power loss, for example), this causes the ..."},"1032":{y:0,u:"../Content/device_firmware_update_guide/dfu_FW_AppBLEStackUpdate.htm",l:-1,t:"Application + FOTA Bluetooth Low Energy Stack Update",i:0.000447713649571742,a:"This type of update is performed in multiple steps: Start the DFU component. When the FOTA process receives a Bluetooth Low Energy stack image instead of an application image, no revision check is performed, and the downloaded image is saved in the download area. The FOTA process executes code from the Bluetooth Low Energy stack area, so it is not possible to directly replace the Bluetooth Low Energy stack. After completely programming the new Bluetooth Low Energy stack image into the download area, the DFU component performs a reset and thereby activates the bootloader. The bootloader detects a valid Bluetooth Low Energy stack image in the download area and copies it to the Bluetooth Low Energy stack area. This is now possible because the previous Bluetooth Low Energy stack is no longer needed. After successfully copying the new Bluetooth Low Energy stack, the bootloader invalidates the Bluetooth Low Energy stack in the download area and proceeds with the firmware startup. As with a ..."},});