define({"1033":{y:0,u:"../Content/device_firmware_update_guide/dfu_1stUpdate_LP.htm",l:-1,t:"Performing Your First FOTA Update",i:0.000955687921376451,a:"Before we dive into all details regarding the FOTA tools, firmware images, and protocol specifications, this topic walks you step-by-step through the process of performing your first FOTA update. The goal is to provide you a basic hands-on understanding of the RSL FOTA update process, and to ensure that your hardware and software are correctly setup. This topic shows how to: Generate a FOTA firmware image using the preconfigured ble_peripheral_server_fota sample application. This application is similar to the ble_peripheral_server application with added features to support FOTA updates. Set up the RSLbootloader and load a firmware image using UART. Perform a FOTA update using BLE Explorer. Alternatively, a FOTA update can be performed using the mobile application. See  RSL FOTA Mobile Application . For information on performing a secure FOTA update with a secure application, refer to the instructions and examples in the secure_blinky_fota sample application’s readme file. This tutorial ..."},"1034":{y:0,u:"../Content/device_firmware_update_guide/dfu_1stUpdate_GenerateImage.htm",l:-1,t:"Generating the FOTA Firmware Image",i:0.000778670424020972,a:"Open the Examples tab in the Pack Manager perspective to see example projects, included in the RSL CMSIS-Pack. Find the ble_peripheral_server_fota example project and click the Copy button to import it into your workspace. (See the  \"Importing the FOTA Sample Project\" figure .) Importing the FOTA Sample Project The C/C++ perspective opens and displays your newly copied project. In the Project Explorer panel, you can expand your project folder and explore the files inside your project, as seen in the  \"Files in FOTA Sample Project\" figure . On the right side, the ble_peripheral_server_fota.rteconfig file displays the selected software components, including the new component named FOTA. If you expand RTE \u003e Device \u003e \u003cdevice\u003e, you can find the FOTA library (libfota.a), the FOTA Bluetooth Low Energy Stack binary file (fota.bin), and mkfotaimg.exe. These files are automatically added to your sample project once the FOTA component is selected. Files in FOTA Sample Project Build the ..."},"1035":{y:0,u:"../Content/device_firmware_update_guide/dfu_1stUpdate_BootloadUART.htm",l:-1,t:"Setting Up the  Bootloader and Loading a Firmware Image Using UART",i:0.00636761412939322,a:"If you are running a FOTA update for the first time, your RSL EVB does not have the bootloader flashed into it. Set up the bootloader using these steps: Import the bootloader sample application, available in the Examples tab. Build the bootloader sample application and flash bootloader.hex. Connect the GPIO defined as the UPDATE_GPIO in the bootloader sample application to the ground and reset your board. After reset, your RSL EVB has activated its updater mode. In this mode, the bootloader is waiting for commands over UART to download a new user application firmware image. Use the Windows Device Manager to find out the COM port number assigned to your RSL EVB, identified by the J-Link CDC UART Port (COM3, as seen in the  \"RSL EVB Com Port Number\" figure ): RSL EVB Com Port Number Using a command prompt, navigate to the bootloader/utility folder. You can see the updater.py tool together with additional .dll dependencies. Invoke the updater.py tool to load the ..."},"1036":{y:0,u:"../Content/device_firmware_update_guide/dfu_1stUpdate_BLEExplorer.htm",l:-1,t:"Performing a FOTA Update Using BLE Explorer",i:0.00298346005075112,a:"Performing a FOTA Update Using BLE Explorer BLE Explorer is a desktop application that runs on Windows®, developed to work with the RSL USB Dongle. To use BLE Explorer for a FOTA update, follow these steps: Connect FOTA_GPIO (GPIO1) to ground. After a few seconds, you can see the name RSL FOTA on the RSL BLE Explorer, as shown in the  \"FOTA Running\" figure . After checking the name RSL FOTA, disconnect FOTA_GPIO from ground. Click on the Update Firmware option on the BLE Explorer and select the ble_peripheral_server_fota.fota image file. (See Chapter 1 \"Performing FOTA Update with BLE Explorer\" on page 1). There is a 30-second wait for image file selection. After 30 seconds, control returns to the ble_peripheral_server_fota application. FOTA Running Once the FOTA firmware image file is selected, it starts updating the firmware, as shown in the  \"Updating Firmware\" figure . Updating Firmware Upon firmware update completion, Firmware update succeeded is displayed."},"1037":{y:0,u:"../Content/device_firmware_update_guide/dfu_Image_LP.htm",l:-1,t:"FOTA Image",i:0.000447713649571742,a:"FOTA Image The FOTA Image (.fota file) consists of two sub-images, with padding to a multiple of 2048 bytes in between so that the start of the second image lies on an RSL flash sector boundary.  For more information about this topic, see:"},"1038":{y:0,u:"../Content/device_firmware_update_guide/dfu_Image_Overview.htm",l:-1,t:"Overview",i:0.00298346005075112,a:"Overview The FOTA image’s first sub-image is the FOTA Bluetooth Low Energy Stack (fota.bin) and the second one is the user application (app.bin). The Python utility mkfotaimg.py generates the FOTA image, as illustrated below in the  \"Image Format\" figure :   Image Format The .fota file can then be used as input to the updater.py tool to perform a UART firmware update via the bootloader. For more information about the bootloader, see the Bootloader User\u0027s Guide."},"1039":{y:0,u:"../Content/device_firmware_update_guide/dfu_Image_MKFOTAIMG.htm",l:-1,t:"mkfotaimg.py",i:0.000778670424020972,a:"The mkfotaimg.py tool takes two positional arguments as inputs: the FOTA Bluetooth Low Energy stack sub-image and the user application sub-image. Its usage and optional arguments are shown below. Usage: \u003e mkfotaimg.py [-h] [--version] [-d UUID] [-s SecureBoot] [-i UUID][-n NAME] [-o OUT-IMG] FOTA-IMG APP-IMG Arguments: see the  \"Positional Arguments\" table  and the  \"Optional Arguments\" table .     This Python utility can be integrated into the post-build steps of Eclipse to generate the .fota format file every time a user application project is built. This configuration is available in Project \u003e Properties \u003e C/C++ Build \u003e Settings \u003e Build Steps \u003e Post-Build Steps. Two steps are required to generate the .fota image. First, we need to generate the app.bin, which is the application sub-image. This is done using the objcopy tool, as follows: arm-none-eabi-objcopy -O binary \u003capp_name\u003e.elf \u003capp_name\u003e.bin Then, we can call the mkfotaimg.py utility to generate the final FOTA image (app.fota ..."},"1040":{y:0,u:"../Content/device_firmware_update_guide/dfu_Image_SubImageFormat.htm",l:-1,t:"Sub-Image Format",i:0.00518824967748127,a:"A sub-image contains the 1-to-1 flash content for RSL devices. We use positions 8 and 9 of the vector table to store pointers for the version info and the image descriptor, as shown in the  \"Vector Table Positions\" figure : Vector Table Positions Every vector is a 32-bit value. With the Reset handler vector, the image start address can be calculated as: To find the version info and image descriptor, we calculate the corresponding image offsets by subtracting the image start address from the vector value: All multi-byte values in the description are in little-endian format. The version info has the following format: typedef struct {     char     id[6];       /* ID string */     uint16_t num;         /* \u003cmajor[15:12]\u003e.\u003cminor[11:8]\u003e.\u003crevision[7:0]\u003e */ } version;   typedef struct {     version  img_ver     /* image version */     uint8_t  dev_id[16]; /* device UUID set by mkfotaimg (default all 0s) */ } version_info; In the FOTA stack sub-image, the version info is directly followed by a ..."},"1041":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_LP.htm",l:-1,t:"The DFU",i:0.000778670424020972,a:"The DFU The Device Firmware Update (DFU) component, which is embedded in the FOTA stack, acts as the server for the DFU service. This component performs the actual update via the DFU custom service.  For more information about this topic, see:"},"1042":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_Component.htm",l:-1,t:"DFU Component",i:0.000447713649571742,a:"DFU Component The DFU component is activated automatically at device startup if no valid application sub-image is found on the device. The application can also start the DFU component by calling the function Sys_Fota_StartDfu()."},"1043":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_UpdateSeq.htm",l:-1,t:"Update Sequence",i:0.000447713649571742,a:"The DFU client scans for a device advertising the configured service ID (normally the DFU service ID). When the device is found, the DFU client connects to the device and reads its characteristics (Device ID, Versions, Build ID). The client must only accept FOTA images with matching Device IDs, unless the Device ID characteristic is all 0s, which means the device is compatible with all FOTA images. If the Build ID of the application sub-image differs from the Build ID characteristic, the client needs to download the FOTA stack sub-image first. After this downloads successfully, the client needs to disconnect from the device, which restarts the device with the new FOTA stack. Now the client needs to reconnect to the same device. If the Build ID of the application sub-image matches the Build ID characteristic, the client needs to download the Application sub-image. After successfully downloading, the client needs to disconnect from the device, which restarts the device with the new user ..."},"1044":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_StackSRCCode.htm",l:-1,t:"FOTA Stack Source Code",i:0.000778670424020972,a:"The RSL CMSIS-Pack includes a prebuilt version of the FOTA Stack available in the form of a software component, as shown in  Performing Your First FOTA Update . The fota.bin and libfota.a files are located under \u003ccmsis_pack_root\u003e\\ONSemiconductor\\\u003cdevice\u003e\\\u003cversion\u003e\\lib\\Release. The source code to generate these files is also available in the CMSIS-Pack, under \u003ccmsis_pack_root\u003e\\ONSemiconductor\\\u003cdevice\u003e\\\u003cversion\u003e\\firmware\\source\\lib\\fota. If you would like to customize and rebuild these files, follow these steps: Import the source code project. Navigate to File \u003e Import \u003e General \u003e Existing Projects into Workspace, set the Select root directory: option with the path to the source code \u003ccmsis_pack_root\u003e\\ONSemiconductor\\\u003cdevice\u003e\\\u003cversion\u003e\\firmware\\source\\lib\\fota, mark the checkbox Copy projects into workspace, and click Finish. The project appears in the left side of Project Explorer, as shown in the  \"Copying the Project\" figure .   Copying the Project Modify the source code. For example, ..."},"1045":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_BLEService.htm",l:-1,t:"DFU Bluetooth Low Energy Service",i:0.00298346005075112,a:"DFU Bluetooth Low Energy Service On the RSL device the DFU service is used as the server; the DFU service client runs on the PC (BLE Explorer). The  \"DFU Service UUID\" table  shows the UUID of the DFU service.   If the device application does not implement this service, another method must be used to activate the DFU mode in the device (e.g. connect FOTA_GPIO to ground)."},"1046":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_SrvCharacteristics.htm",l:-1,t:"DFU Service Characteristics",i:0.0055192064519305,a:"DFU Service Characteristics The  \"DFU Service Characteristics and Their Properties\" table  lists the DFU service characteristics and provides information about them."},"1047":{y:0,u:"../Content/device_firmware_update_guide/dfu_DFU_Protocol.htm",l:-1,t:"DFU Protocol",i:0.00298346005075112,a:"The application layer uses a Command/Response scheme. Every Command/Response consists of a standard header and an optional body. The header has the following format: typedef struct {     uint8_t  code;     /* unique Command/Response code */     uint8_t  param[3]; /* Command/Response specific parameters*/     uint32_t body_len; /* length of the following body (0 = no body)*/ } header; Currently only a single Command/Response is specified: IMAGE_DOWNLOAD (code = 1). The command is used to transfer a sub-image to the RSL device. The three parameters are not used by the command and must be set to 0. The body contains one of the two sub-images including the signature. The response signals back the success or failure of the operation; in the case of failure, the RSL device can send the response before the whole command body is transferred. The response itself has no body. Param[0] is used for the status; the other parameters are not used, and must be set to 0. The  \"Status Codes\" table , ..."},"1048":{y:0,u:"../Content/device_firmware_update_guide/dfu_Integ_LP.htm",l:-1,t:"Integrating FOTA Into Your Application",i:0.000778670424020972,a:"Integrating FOTA Into Your Application This topic shows how to modify an existing sample application to make it capable of receiving FOTA updates. We start with the ble_peripheral_direction_finding application, and walk you step-by-step through all the required project configurations and firmware changes. Then we show how to perform a FOTA update to confirm that the integration has been executed successfully. This information refers to the general FOTA usage. For information on performing a secure FOTA update, refer to the instructions and examples in the secure_blinky_fota sample application’s readme file. For more information about this topic, see:"},"1049":{y:0,u:"../Content/device_firmware_update_guide/dfu_Integ_Modifying.htm",l:-1,t:"Modifying the Application",i:0.00298346005075112,a:"Modify the application with the following steps: Copy the ble_peripheral_direction_finding sample application into your workspace. The C/C++ perspective opens and displays your newly copied project, as shown below in the  \"Bringing the Project Into the Workspace\" figure . Bringing the Project Into the Workspace Add the FOTA software component to your project by using the RTE Configuration Wizard (the ble_peripheral_direction_finding.rteconfig file). When you select the FOTA component and click save, libfota.a, fota.bin, mkfotaimg.exe and the tool mkfotaimg.py are copied into your project, under RTE \u003e Device \u003e \u003cdevice\u003e. In addition, you need to deselect the BLE Stack  component as shown in the  \"Adding the FOTA Software Component\" figure . Adding the FOTA Software Component Modify the source code to set the FOTA version number and ID: In app.h, define your version numbers and ID: /*-------------------------------------------- * Application Version * ..."},"1050":{y:0,u:"../Content/device_firmware_update_guide/dfu_Integ_PerformUpdate.htm",l:-1,t:"Performing a FOTA Update",i:0.000624731146927222,a:"Make sure you have bootloader running on your RSL EVB. If you have executed the steps in  Performing Your First FOTA Update , you already have bootloader flashed on your board and you can skip this step. Otherwise, refer to  Setting Up the  Bootloader and Loading a Firmware Image Using UART  for instructions. Activate the bootloader updater mode: Connect the UPDATE_GPIO from the bootloader application to ground on the RSL EVB, and then push the reset button. The bootloader updater is now active, waiting for a firmware image over UART.  If there is a valid user application in flash (for example, the ble_peripheral_server_fota) and no command is received over UART after 30 seconds, the bootloader updater times out and reboots into the user application. Load the ble_peripheral_direction_finding.fota image using the bootloader with the following command: \u003e python updater.py COM3 ble_peripheral_direction_finding.fota Image      : DF ver= 1.0.0 / FOTA   ver=1.0.0 Application: FOTA ver=1.0.0 ..."},"1051":{y:0,u:"../Content/device_firmware_update_guide/dfu_SecureBLE_LP.htm",l:-1,t:"The Secure Bluetooth Low Energy FOTA Application",i:0.000447713649571742,a:"The Secure Bluetooth Low Energy FOTA Application The secure_blinky_fota application shows how the firmware of a secure non-Bluetooth Low Energy application is updated by FOTA and how to sign the firmware. Here you can learn how to create a secure Bluetooth Low Energy FOTA application and how to update the application\u0027s firmware via FOTA. For more information about this topic, see:"},"1052":{y:0,u:"../Content/device_firmware_update_guide/dfu_SecureBLE_Working.htm",l:-1,t:"Working with ble_peripheral_server_fota",i:0.00298346005075112,a:"Before starting to create a secure Bluetooth Low Energy FOTA application, you must have a provisioned RSL15 Evaluation and Development Board and the BLE Explorer utility. This section is divided into four steps: of generating the application\u0027s firmware image, the signing process, making FOTA image, and testing. Step 1: Generate the application’s firmware image To generate the firmware image, perform these steps: Import the secure_bootloader and build with the bl_D_Secure configuration option. After building successfully, secure_bootloader.hex is generated under the bl_D_Secure folder. Import the FOTA project. Navigate to File \u003e Import \u003e General \u003e Existing Projects into Workspace, set the Select root directory: option with the path to the source code \u003ccmsis_pack_root\u003e/ONSemiconductor/\u003cdevice\u003e/\u003cversion\u003e/firmware/source/lib/fota, mark the checkbox Copy projects into workspace, and click Finish. The project appears in the left side of the Project Explorer view. Build the project with the ..."},"1053":{y:0,u:"../Content/device_firmware_update_guide/dfu_Mobile_LP.htm",l:-1,t:"RSL FOTA Mobile Application",i:0.00164067969053664,a:"RSL FOTA Mobile Application RSL FOTA is a simple mobile application for iOS and Android, created to demonstrate Firmware-Over-The-Air (FOTA) for onsemi RSL Bluetooth Low Energy devices. The RSL FOTA application acts as a central device to scan, connect and transmit the firmware image to a remote device. The remote RSL device firmware must have FOTA-enabled firmware to receive the FOTA firmware image. For more information about this topic, see:"},"1054":{y:0,u:"../Content/device_firmware_update_guide/dfu_Mobile_FOTAApp.htm",l:-1,t:"RSL FOTA Application",i:0.00298346005075112,a:"RSL FOTA Application Follow these steps to use the RSL FOTA Mobile Application: Download and install the RSL FOTA application from the  Google Play Store or the  Apple App Store. Launch the application and select the FOTA enabled firmware device from the list of devices, as shown below in the  \"RSL FOTA Mobile Application Showing Bluetooth Low Energy Devices\" figure . RSL FOTA Mobile Application Showing Bluetooth Low Energy Devices When the appropriate device is selected, select the firmware image by clicking the Select File button. Once the FOTA firmware image file is selected, click the Update button (see the  \"RSL FOTA Mobile Application: Updating Firmware\" figure ). RSL FOTA Mobile Application: Updating Firmware Upon firmware update completion, Update finished with code: 0 (Success) is displayed."},"1055":{y:0,u:"../Content/device_firmware_update_guide/dfu_Mobile_AndroidLimits.htm",l:-1,t:"RSL FOTA Android Limitations",i:0.000447713649571742,a:"RSL FOTA Android Limitations Note the following important details when using the RSL FOTA Mobile Application: Android must be version 6.0 or higher. Device location permission is needed to scan for Bluetooth Low Energy devices. If the permission is not granted at app startup, the app is prevented from finding any Bluetooth Low Energy devices. Device storage permission is needed to select a FOTA file. The FOTA file can be selected from the Downloads folder. The file can be transferred to the device, either over USB or by email."},"1056":{y:0,u:"../Content/device_firmware_update_guide/dfu_Mobile_iOSLimits.htm",l:-1,t:"RSL FOTA iOS Limitations",i:0.000447713649571742,a:"RSL FOTA iOS Limitations Note the following important details when using the RSL FOTA iOS® Mobile Application: The RSL FOTA Mobile Application for iOS requires the Bluetooth Low Energy feature to be enabled to scan for Bluetooth Low Energy devices. The easiest way to add a new FOTA file to the RSL FOTA Mobile Application is to send an email to the device with the file attached. After downloading the file from the email, press the File icon once more, and a popup is displayed where the user can select which app to use to open the file. Select the  RSL FOTA Mobile Application. The file is then imported to the application, and is visible when the user presses the Select File button on the Update Firmware screen."},"1057":{y:0,u:"../Content/evaluation_development_board_rsl15/evb_LP.htm",l:-1,t:"Evaluation and Development Board Manual",i:0.000447713649571742,a:"Evaluation and Development Board Manual For information about the Evaluation and Development Board (EVB) Manual and its schematics, go to the  RSL15 web page  and navigate to the EVB page."},"1058":{y:0,u:"../Content/common_topics/Glossary.htm",l:-1,t:"Glossary",i:0.000447713649571742,a:"The following abbreviations and terms are used in this documentation: ACS analog control system ADC analog-to-digital converter AoA angle of arrival AoD angle of departure Arm Cortex-M33 processor processing core that can be used to configure the overall system after initial boot, and is typically used to coordinate the system interaction with external components ASCC audio sink clock counter CC312 Arm TrustZone CryptoCell-312 Security IP CCIT Causal Conditional Inference Tree CID chip identifier CM chip manufacture life cycle state CMSIS Cortex Microcontroller Software Interface Standard CRC cyclic redundancy check CS chip select DAC digital-to-analog converter DM device manufacture life cycle state DMA direct memory access DNL differential non-linearity DSP digital signal processor ECC error correcting code EH energy harvesting EVB Evaluation and Development Board FIFO A section of memory that is treated as a buffer where components that use this memory use pointers to handle data in ..."},"1059":{y:0,u:"../Content/common_topics/change_history.htm",l:-1,t:"Change History",i:0.000447713649571742,a:"Change History This table provides a summary of documentation changes made with each release."},"1060":{y:0,u:"../Content/common_topics/rights_disclaimers_pubOrdering.htm",l:-1,t:"rights_disclaimers_pubOrdering",i:0.000447713649571742,a:"Sections of this manual relating to the Arm Cortex-M33 processor have been republished from the Cortex-M33 Technical Reference (version r0p2) with permission.                           Arm, the Arm logo and Cortex are trademarks or registered trademarks of Arm Ltd. Bluetooth is a registered trademark of Bluetooth SIG, Inc. All other brand names and product names appearing in this document are trademarks of their respective holders.   Windows is a registered trademark of Microsoft Corporation. Arm, Cortex, Keil, and uVision are registered trademarks of Arm Limited (or its subsidiaries) in the US and/or elsewhere. All other brand names and product names appearing in this document are trademarks of their respective holders.   IAR Embedded Workbench is a registered trademark of IAR Systems AB.   onsemi and the onsemi logo are trademarks of Semiconductor Components Industries, LLC dba onsemi or its subsidiaries in the United States and/or other countries. onsemi owns the rights to a number ..."},"1061":{y:0,u:"../Content/common_topics/inappropriate_terminology.htm",l:-1,t:"Notice: Inappropriate Terminology",i:0.000447713649571742,a:"Notice: Inappropriate Terminology onsemi acknowledges that this document contain the inappropriate terms “white list”, “master” and “slave”. We have a plan to work with other companies to identify an industry wide solution that can eradicate non-inclusive terminology but maintains the technical relationship of the original wording. Once new terminologies are agreed upon, future products will contain new terminology."},"1062":{y:0,u:"../Content/common_topics/Search_Syntax.htm",l:-1,t:"Searching this Documentation",i:0.000542857707927759,a:"Searching this Documentation The following table shows the syntax for different types of searches. Search for up to 10 words, phrases, or parts of words. Results are highlighted in yellow on the pages where they are found. What You Are Searching For Syntax in Search Box Several terms on the same page (“AND” search) Term1 + Term2 Any of several terms on a page (“OR” search) Term1 Term2  An item on a page, excluding another item (“NOT” search) Term1 ! Term2 Alternate syntax for the above “NOT” search Term1 ^ Term2 Exact phrases “Multiple Word Phrase”"},"1063":{y:0,u:"../Content/common_topics/Conventions.htm",l:-1,t:"Document Conventions",i:0.000542857707927759,a:"The following typographical conventions are used in this documentation:   monospace font Assembly code, macros, functions, registers, defines and addresses. italics File and path names, or any portion of them. \u003cangle brackets and bold\u003e Optional parameters and placeholders for specific information. To use an optional parameter or replace a placeholder, specify the information within the brackets; do not include the brackets themselves. Bold GUI items (text that can be seen on a screen). Note, Important, Caution, Warning   Information requiring special notice is presented in several attention-grabbing formats depending on the consequences of ignoring the information: Significant supplemental information, hints, or tips. Information that can prevent you from damaging equipment or software. Registers:   Registers are shown in monospace font using their full descriptors, depending on which core the register is accessing. The full description takes the form \u003cPREFIX\u003e\u003cGROUP\u003e_\u003cREGISTER\u003e.  All ..."},"1064":{y:0,u:"../Content/common_topics/More_Information.htm",l:-1,t:"More Information",i:0.000542857707927759,a:"The following documents are installed with the RSL15 system, in the default location C:/Users/\u003cyour_user_name\u003e/AppData/Local/Arm/Packs/ONSemiconductor/RSL15/\u003cversion_number\u003e/documentation. These manuals are available only in PDF format: Arm TrustZone CryptoCell-312 Software Developers Manual multiple CEVA manuals in the /ceva folder For even more information, consult these publicly-available documents: Armv8M Architecture Reference Manual (PDF download available from  https://developer.arm.com/documentation/ddi0553/latest ). Arm Cortex-M33 Processor Technical Reference Manual, revision r1p0, from  https://developer.arm.com/documentation/100230/0100 Bluetooth Core Specification version 5.2, available from  https://www.bluetooth.com/specifications/adopted-specifications TrustZone documentation available from the Arm website at  https://developer.arm.com/ip-products/security-ip/trustzone/trustzone-for-cortex-m Other ArmCortex-M33 publications, available from the Arm website at  ..."},});